/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal;

import com.microsoft.applicationinsights.agent.internal.config.AgentConfiguration;
import com.microsoft.applicationinsights.agent.internal.config.BuiltInInstrumentation;
import com.microsoft.applicationinsights.agent.internal.config.ClassInstrumentationData;
import com.microsoft.applicationinsights.agent.internal.config.MethodInfo;
import com.microsoft.applicationinsights.agent.internal.config.builder.XmlAgentConfigurationBuilder;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Splitter;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.Method;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig;
import org.glowroot.instrumentation.engine.config.ImmutableInstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptors;

class AIAgentXmlLoader {
    private static final Logger logger = LoggerFactory.getLogger(AIAgentXmlLoader.class);

    AIAgentXmlLoader() {
    }

    static AgentConfiguration load(File agentJarParentFile) {
        return new XmlAgentConfigurationBuilder().parseConfigurationFile(agentJarParentFile.getAbsolutePath());
    }

    static List<InstrumentationDescriptor> getInstrumentationDescriptors(AgentConfiguration agentConfiguration) throws IOException {
        BuiltInInstrumentation builtInConfiguration = agentConfiguration.getBuiltInInstrumentation();
        boolean httpEnabled = builtInConfiguration.isHttpEnabled();
        boolean jdbcEnabled = builtInConfiguration.isJdbcEnabled();
        boolean loggingEnabled = builtInConfiguration.isLoggingEnabled();
        boolean redisEnabled = builtInConfiguration.isJedisEnabled();
        ArrayList<InstrumentationDescriptor> instrumentationDescriptors = new ArrayList<InstrumentationDescriptor>();
        block15: for (InstrumentationDescriptor instrumentationDescriptor : InstrumentationDescriptors.read()) {
            switch (instrumentationDescriptor.id()) {
                case "apache-http-client": 
                case "http-url-connection": 
                case "okhttp": {
                    if (!httpEnabled) continue block15;
                    instrumentationDescriptors.add(instrumentationDescriptor);
                    continue block15;
                }
                case "jdbc": {
                    if (!jdbcEnabled) continue block15;
                    instrumentationDescriptors.add(instrumentationDescriptor);
                    continue block15;
                }
                case "log4j": 
                case "logback": {
                    if (!loggingEnabled) continue block15;
                    instrumentationDescriptors.add(instrumentationDescriptor);
                    continue block15;
                }
                case "redis": {
                    if (!redisEnabled) continue block15;
                    instrumentationDescriptors.add(instrumentationDescriptor);
                    continue block15;
                }
            }
            instrumentationDescriptors.add(instrumentationDescriptor);
        }
        InstrumentationDescriptor instrumentationDescriptor = AIAgentXmlLoader.buildCustomInstrumentation(agentConfiguration);
        if (instrumentationDescriptor != null) {
            instrumentationDescriptors.add(instrumentationDescriptor);
        }
        return instrumentationDescriptors;
    }

    static Map<String, Map<String, Object>> getInstrumentationConfig(BuiltInInstrumentation builtInConfiguration) {
        HashMap<String, Map<String, Object>> instrumentationConfiguration = new HashMap<String, Map<String, Object>>();
        HashMap<String, Boolean> servletConfiguration = new HashMap<String, Boolean>();
        servletConfiguration.put("captureRequestServerHostname", true);
        servletConfiguration.put("captureRequestServerPort", true);
        servletConfiguration.put("captureRequestScheme", true);
        HashMap<String, Object> jdbcConfiguration = new HashMap<String, Object>();
        jdbcConfiguration.put("captureBindParametersIncludes", Collections.emptyList());
        jdbcConfiguration.put("captureResultSetNavigate", false);
        jdbcConfiguration.put("captureGetConnection", false);
        jdbcConfiguration.put("explainPlanThresholdMillis", builtInConfiguration.getQueryPlanThresholdInMS());
        String loggingThreshold = builtInConfiguration.getLoggingThreshold();
        HashMap<String, String> log4jConfiguration = new HashMap<String, String>();
        log4jConfiguration.put("threshold", loggingThreshold);
        HashMap<String, String> logbackConfiguration = new HashMap<String, String>();
        logbackConfiguration.put("threshold", loggingThreshold);
        instrumentationConfiguration.put("servlet", servletConfiguration);
        instrumentationConfiguration.put("jdbc", jdbcConfiguration);
        instrumentationConfiguration.put("log4j", log4jConfiguration);
        instrumentationConfiguration.put("logback", logbackConfiguration);
        return instrumentationConfiguration;
    }

    private static InstrumentationDescriptor buildCustomInstrumentation(AgentConfiguration agentConfiguration) {
        ArrayList<ImmutableAdviceConfig> adviceConfigs = new ArrayList<ImmutableAdviceConfig>();
        for (Map.Entry<String, ClassInstrumentationData> classEntry : agentConfiguration.getClassesToInstrument().entrySet()) {
            String className = classEntry.getKey();
            if (!AIAgentXmlLoader.validJavaFqcn(className)) {
                logger.warn("Invalid class name: {}", (Object)className);
                continue;
            }
            ClassInstrumentationData classInstrumentationData = classEntry.getValue();
            for (Map.Entry<String, Map<String, MethodInfo>> methodNameEntry : classInstrumentationData.getMethodInfos().entrySet()) {
                String methodName = methodNameEntry.getKey();
                if (!AIAgentXmlLoader.validJavaIdentifier(methodName)) {
                    logger.warn("Invalid method name: {}", (Object)methodName);
                    continue;
                }
                Map<String, MethodInfo> methodInfos = methodNameEntry.getValue();
                for (Map.Entry<String, MethodInfo> entry : methodInfos.entrySet()) {
                    MethodInfo methodInfo = entry.getValue();
                    String signature = entry.getKey();
                    ImmutableAdviceConfig.Builder adviceConfig = ImmutableAdviceConfig.builder().className(className).methodName(methodName);
                    if (signature.equals("")) {
                        adviceConfig.addMethodParameterTypes("..");
                    } else {
                        Method method = new Method(methodName, signature);
                        for (Type type : method.getArgumentTypes()) {
                            adviceConfig.addMethodParameterTypes(type.getClassName());
                        }
                        adviceConfig.methodReturnType(method.getReturnType().getClassName());
                    }
                    adviceConfigs.add(adviceConfig.captureKind(AdviceConfig.CaptureKind.LOCAL_SPAN).spanMessageTemplate("__custom," + className + "," + methodName + "," + methodInfo.getThresholdInMS() + "," + classInstrumentationData.getClassType()).timerName("custom").build());
                }
            }
        }
        if (adviceConfigs.isEmpty()) {
            return null;
        }
        return ImmutableInstrumentationDescriptor.builder().id("__custom").name("__custom").addAllAdviceConfigs(adviceConfigs).build();
    }

    @VisibleForTesting
    static boolean validJavaFqcn(String fqcn) {
        List<String> parts = Splitter.on('.').splitToList(fqcn);
        if (parts.isEmpty()) {
            return false;
        }
        for (int i = 0; i < parts.size() - 1; ++i) {
            if (AIAgentXmlLoader.validJavaIdentifier(parts.get(i))) continue;
            return false;
        }
        return AIAgentXmlLoader.validJavaIdentifier(parts.get(parts.size() - 1));
    }

    @VisibleForTesting
    static boolean validJavaIdentifier(String identifier) {
        if (identifier.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (Character.isJavaIdentifierPart(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

