/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal;

import com.microsoft.applicationinsights.agent.internal.AIAgentXmlLoader;
import com.microsoft.applicationinsights.agent.internal.AgentImpl;
import com.microsoft.applicationinsights.agent.internal.config.AgentConfiguration;
import com.microsoft.applicationinsights.agent.internal.config.BuiltInInstrumentation;
import com.microsoft.applicationinsights.agent.internal.model.Global;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.List;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.impl.SimpleConfigServiceFactory;
import org.glowroot.instrumentation.engine.init.EngineModule;
import org.glowroot.instrumentation.engine.init.MainEntryPointUtil;

public class MainEntryPoint {
    @Nullable
    private static Logger startupLogger;

    private MainEntryPoint() {
    }

    public static void premain(Instrumentation instrumentation, File agentJarFile) {
        try {
            startupLogger = MainEntryPoint.initLogging(instrumentation, agentJarFile);
            startupLogger.info("ApplicationInsights agent starting...");
            MainEntryPoint.start(instrumentation, agentJarFile);
            startupLogger.info("ApplicationInsights agent started");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            if (startupLogger != null) {
                startupLogger.error("Agent failed to start.", t);
            }
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger initLogging(Instrumentation instrumentation, File agentJarFile) {
        File logbackXmlOverride = new File(agentJarFile.getParentFile(), "ai.logback.xml");
        if (logbackXmlOverride.exists()) {
            System.setProperty("ai.logback.configurationFile", logbackXmlOverride.getAbsolutePath());
        }
        try {
            Logger logger = MainEntryPointUtil.initLogging("com.microsoft.applicationinsights", instrumentation);
            return logger;
        }
        finally {
            System.clearProperty("ai.logback.configurationFile");
        }
    }

    private static void start(Instrumentation instrumentation, File agentJarFile) throws Exception {
        File agentJarParentFile = agentJarFile.getParentFile();
        File javaTmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpDir = new File(javaTmpDir, "appinsights-java");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new Exception("Could not create directory: " + tmpDir.getAbsolutePath());
        }
        AgentConfiguration agentConfiguration = AIAgentXmlLoader.load(agentJarParentFile);
        BuiltInInstrumentation builtInInstrumentation = agentConfiguration.getBuiltInInstrumentation();
        if (!builtInInstrumentation.isEnabled()) {
            return;
        }
        Global.setOutboundW3CEnabled(builtInInstrumentation.isW3cEnabled());
        Global.setOutboundW3CBackCompatEnabled(builtInInstrumentation.isW3cBackCompatEnabled());
        List<InstrumentationDescriptor> instrumentationDescriptors = AIAgentXmlLoader.getInstrumentationDescriptors(agentConfiguration);
        SimpleConfigServiceFactory configServiceFactory = new SimpleConfigServiceFactory(instrumentationDescriptors, AIAgentXmlLoader.getInstrumentationConfig(builtInInstrumentation));
        EngineModule.createWithSomeDefaults(instrumentation, tmpDir, Global.getThreadContextThreadLocal(), instrumentationDescriptors, configServiceFactory, new AgentImpl(), false, Collections.singletonList("com.microsoft.applicationinsights.agent"), Collections.singletonList("com.microsoft.applicationinsights.agent"), agentJarFile);
    }
}

