/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.jar.JarFile;

public class Premain {
    private Premain() {
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        try {
            CodeSource codeSource = Premain.class.getProtectionDomain().getCodeSource();
            File agentJarFile = Premain.getAgentJarFile(codeSource);
            instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(agentJarFile));
            Class<?> mainEntryPointClass = Class.forName("com.microsoft.applicationinsights.agent.internal.MainEntryPoint", true, Premain.class.getClassLoader());
            Method premainMethod = mainEntryPointClass.getMethod("premain", Instrumentation.class, File.class);
            premainMethod.invoke(null, instrumentation, agentJarFile);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            System.err.println("Agent failed to start: " + t.getLocalizedMessage());
            t.printStackTrace();
        }
    }

    private static File getAgentJarFile(CodeSource codeSource) throws IOException, URISyntaxException {
        if (codeSource == null) {
            throw new IOException("Could not determine agent jar location.");
        }
        File file = new File(codeSource.getLocation().toURI());
        if (file.getName().endsWith(".jar")) {
            return file;
        }
        throw new IOException("Could not find agent jar, found: " + file.getAbsolutePath());
    }
}

