/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.config;

import com.microsoft.applicationinsights.agent.internal.config.MethodInfo;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;

public class ClassInstrumentationData {
    public static final String OTHER_TYPE = "OTHER";
    public static final String ANY_SIGNATURE_MARKER = "";
    private final String classType;
    private final long thresholdInMS;
    private final Map<String, Map<String, MethodInfo>> methodInfos = new HashMap<String, Map<String, MethodInfo>>();

    public ClassInstrumentationData(String classType, long thresholdInMS) {
        this.classType = classType;
        this.thresholdInMS = thresholdInMS;
    }

    public String getClassType() {
        return this.classType;
    }

    public long getThresholdInMS() {
        return this.thresholdInMS;
    }

    public Map<String, Map<String, MethodInfo>> getMethodInfos() {
        return this.methodInfos;
    }

    public void addMethod(String methodName, String signature, long thresholdInMS) {
        Map<String, MethodInfo> innerMap = this.methodInfos.get(methodName);
        if (innerMap == null) {
            innerMap = new HashMap<String, MethodInfo>();
            this.methodInfos.put(methodName, innerMap);
        }
        MethodInfo methodInfo = new MethodInfo(thresholdInMS);
        if (Strings.isNullOrEmpty(signature)) {
            innerMap.put(ANY_SIGNATURE_MARKER, methodInfo);
        } else {
            innerMap.put(signature, methodInfo);
        }
    }
}

