/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.config.builder;

import com.microsoft.applicationinsights.agent.internal.config.AgentConfiguration;
import com.microsoft.applicationinsights.agent.internal.config.ClassInstrumentationData;
import com.microsoft.applicationinsights.agent.internal.config.builder.BuiltInInstrumentationBuilder;
import com.microsoft.applicationinsights.agent.internal.config.builder.XmlParserUtils;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Strings;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlAgentConfigurationBuilder {
    private static final Logger logger = LoggerFactory.getLogger(XmlAgentConfigurationBuilder.class);
    private static final String AGENT_XML_CONFIGURATION_NAME = "AI-Agent.xml";
    private static final String MAIN_TAG = "ApplicationInsightsAgent";
    private static final String INSTRUMENTATION_TAG = "Instrumentation";
    private static final String CLASS_TAG = "Class";
    private static final String METHOD_TAG = "Method";
    private static final String BUILT_IN_TAG = "BuiltIn";
    private static final String HTTP_TAG = "HTTP";
    private static final String W3C_ENABLED = "W3C";
    private static final String W3C_BACK_COMPAT_ENABLED = "enableW3CBackCompat";
    private static final String JDBC_TAG = "JDBC";
    private static final String LOGGING_TAG = "Logging";
    private static final String JEDIS_TAG = "Jedis";
    private static final String MAX_STATEMENT_QUERY_LIMIT_TAG = "MaxStatementQueryLimitInMS";
    private static final String THRESHOLD_ATTRIBUTE = "thresholdInMS";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SIGNATURE_ATTRIBUTE = "signature";

    public AgentConfiguration parseConfigurationFile(String baseFolder) {
        File configurationFile;
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        String configurationFileName = baseFolder;
        if (!baseFolder.endsWith(File.separator)) {
            configurationFileName = configurationFileName + File.separator;
        }
        if (!(configurationFile = new File(configurationFileName = configurationFileName + AGENT_XML_CONFIGURATION_NAME)).exists()) {
            logger.trace("Did not find Agent configuration file in '{}'", (Object)configurationFileName);
            return agentConfiguration;
        }
        logger.trace("Found Agent configuration file in '{}'", (Object)configurationFileName);
        try {
            Element topElementTag = this.getTopTag(configurationFile);
            if (topElementTag == null) {
                return agentConfiguration;
            }
            NodeList instrumentationTags = topElementTag.getElementsByTagName(INSTRUMENTATION_TAG);
            Element instrumentationTag = XmlParserUtils.getFirst(instrumentationTags);
            if (instrumentationTag == null) {
                return agentConfiguration;
            }
            this.setBuiltInInstrumentation(agentConfiguration, instrumentationTag);
            NodeList classTags = instrumentationTag.getElementsByTagName(CLASS_TAG);
            if (classTags == null) {
                return agentConfiguration;
            }
            HashMap<String, ClassInstrumentationData> classesToInstrument = new HashMap<String, ClassInstrumentationData>();
            for (int i = 0; i < classTags.getLength(); ++i) {
                String className;
                Element classTag = this.getClassDataElement(classTags.item(i));
                if (classTag == null || Strings.isNullOrEmpty(className = classTag.getAttribute(NAME_ATTRIBUTE))) continue;
                ClassInstrumentationData data = (ClassInstrumentationData)classesToInstrument.get(className);
                if (data == null) {
                    data = this.createClassInstrumentationData(classTag);
                    classesToInstrument.put(className, data);
                }
                this.addMethods(data, classTag);
            }
            agentConfiguration.setClassesToInstrument(classesToInstrument);
            return agentConfiguration;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            try {
                logger.error("Exception parsing AI-Agent.xml", e);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }

    private void setBuiltInInstrumentation(AgentConfiguration agentConfiguration, Element instrumentationTags) {
        BuiltInInstrumentationBuilder builtInConfigurationBuilder = new BuiltInInstrumentationBuilder();
        NodeList nodes = instrumentationTags.getElementsByTagName(BUILT_IN_TAG);
        Element builtInElement = XmlParserUtils.getFirst(nodes);
        if (builtInElement == null) {
            builtInConfigurationBuilder.setEnabled(false);
            agentConfiguration.setBuiltInData(builtInConfigurationBuilder.create());
            return;
        }
        boolean builtInIsEnabled = XmlParserUtils.getEnabled(builtInElement, BUILT_IN_TAG);
        builtInConfigurationBuilder.setEnabled(builtInIsEnabled);
        if (!builtInIsEnabled) {
            builtInConfigurationBuilder.setEnabled(false);
            agentConfiguration.setBuiltInData(builtInConfigurationBuilder.create());
            return;
        }
        nodes = builtInElement.getElementsByTagName(HTTP_TAG);
        Element httpElement = XmlParserUtils.getFirst(nodes);
        boolean w3cEnabled = XmlParserUtils.w3cEnabled(httpElement, W3C_ENABLED, false);
        boolean w3cBackCompatEnabled = XmlParserUtils.w3cEnabled(httpElement, W3C_BACK_COMPAT_ENABLED, true);
        builtInConfigurationBuilder.setHttpEnabled(XmlParserUtils.getEnabled(httpElement, HTTP_TAG), w3cEnabled, w3cBackCompatEnabled);
        nodes = builtInElement.getElementsByTagName(JDBC_TAG);
        builtInConfigurationBuilder.setJdbcEnabled(XmlParserUtils.getEnabled(XmlParserUtils.getFirst(nodes), JDBC_TAG));
        nodes = builtInElement.getElementsByTagName(LOGGING_TAG);
        builtInConfigurationBuilder.setLoggingEnabled(XmlParserUtils.getEnabled(XmlParserUtils.getFirst(nodes), LOGGING_TAG), XmlParserUtils.getStringAttribute(XmlParserUtils.getFirst(nodes), "threshold", "warn"));
        nodes = builtInElement.getElementsByTagName(JEDIS_TAG);
        Element element = XmlParserUtils.getFirst(nodes);
        builtInConfigurationBuilder.setJedisEnabled(XmlParserUtils.getEnabled(element, JEDIS_TAG));
        nodes = builtInElement.getElementsByTagName(MAX_STATEMENT_QUERY_LIMIT_TAG);
        builtInConfigurationBuilder.setQueryPlanThresholdInMS(XmlParserUtils.getLong(XmlParserUtils.getFirst(nodes), MAX_STATEMENT_QUERY_LIMIT_TAG));
        agentConfiguration.setBuiltInData(builtInConfigurationBuilder.create());
    }

    private Element getClassDataElement(Node item) {
        boolean isEnabled;
        if (item.getNodeType() != 1) {
            return null;
        }
        Element classNode = (Element)item;
        String strValue = classNode.getAttribute(ENABLED_ATTRIBUTE);
        if (!Strings.isNullOrEmpty(strValue) && !(isEnabled = Boolean.valueOf(strValue).booleanValue())) {
            return null;
        }
        return classNode;
    }

    private ClassInstrumentationData createClassInstrumentationData(Element classTag) {
        String type = classTag.getAttribute("type");
        if (Strings.isNullOrEmpty(type)) {
            type = "OTHER";
        }
        long thresholdInMS = XmlParserUtils.getLongAttribute(classTag, THRESHOLD_ATTRIBUTE, 0L);
        return new ClassInstrumentationData(type, thresholdInMS);
    }

    private void addMethods(ClassInstrumentationData classData, Element classNode) {
        NodeList methodTags = classNode.getElementsByTagName(METHOD_TAG);
        for (int i = 0; i < methodTags.getLength(); ++i) {
            String methodName;
            Element methodTag = (Element)methodTags.item(i);
            if (!XmlParserUtils.getEnabled(methodTag, ENABLED_ATTRIBUTE) || Strings.isNullOrEmpty(methodName = methodTag.getAttribute(NAME_ATTRIBUTE))) continue;
            long thresholdInMS = XmlParserUtils.getLongAttribute(methodTag, THRESHOLD_ATTRIBUTE, classData.getThresholdInMS());
            String signature = methodTag.getAttribute(SIGNATURE_ATTRIBUTE);
            classData.addMethod(methodName, signature, thresholdInMS);
        }
    }

    private Element getTopTag(File configurationFile) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = this.createDocumentBuilder();
        Document doc = builder.parse(new FileInputStream(configurationFile));
        doc.getDocumentElement().normalize();
        NodeList topTags = doc.getElementsByTagName(MAIN_TAG);
        if (topTags == null || topTags.getLength() == 0) {
            return null;
        }
        Node topNodeTag = topTags.item(0);
        if (topNodeTag.getNodeType() != 1) {
            return null;
        }
        return (Element)topNodeTag;
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbFactory.setXIncludeAware(false);
        dbFactory.setExpandEntityReferences(false);
        return dbFactory.newDocumentBuilder();
    }
}

