/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.config.builder;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Strings;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XmlParserUtils {
    private static final Logger logger = LoggerFactory.getLogger(XmlParserUtils.class);
    private static final String ENABLED_ATTRIBUTE = "enabled";

    XmlParserUtils() {
    }

    public static Element getFirst(NodeList nodes) {
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        Node node = nodes.item(0);
        if (node.getNodeType() != 1) {
            return null;
        }
        return (Element)node;
    }

    public static boolean getEnabled(Element element, String elementName) {
        if (element == null) {
            return true;
        }
        try {
            String strValue = element.getAttribute(ENABLED_ATTRIBUTE);
            if (!Strings.isNullOrEmpty(strValue)) {
                return Boolean.parseBoolean(strValue);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to parse attribute '{}' of '{}', default value ({}) will be used.", ENABLED_ATTRIBUTE, elementName, true);
            return true;
        }
    }

    static boolean w3cEnabled(Element element, String attributeName, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        try {
            String strValue = element.getAttribute(attributeName);
            if (!Strings.isNullOrEmpty(strValue)) {
                return Boolean.parseBoolean(strValue);
            }
            return defaultValue;
        }
        catch (Exception e) {
            logger.error("cannot parse the correlation format, will default to AI proprietary correlation", e);
            return defaultValue;
        }
    }

    public static long getLongAttribute(Element element, String attributeName, long defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        try {
            String strValue = element.getAttribute(attributeName);
            if (!Strings.isNullOrEmpty(strValue)) {
                return Long.parseLong(strValue);
            }
            return defaultValue;
        }
        catch (Exception e) {
            logger.error("Failed to parse attribute '{}', default value ({}) will be used.", (Object)attributeName, (Object)defaultValue);
            return defaultValue;
        }
    }

    public static String getStringAttribute(Element element, String attributeName, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String strValue = element.getAttribute(attributeName);
        if (!Strings.isNullOrEmpty(strValue)) {
            return strValue;
        }
        return defaultValue;
    }

    public static Long getLong(Element element, String elementName) {
        if (element == null) {
            return null;
        }
        try {
            Node node = element.getFirstChild();
            if (node == null) {
                return null;
            }
            String strValue = node.getTextContent();
            if (!Strings.isNullOrEmpty(strValue)) {
                return Long.parseLong(strValue);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to parse value of '{}'", (Object)elementName);
            return null;
        }
    }
}

