/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.model;

import com.microsoft.applicationinsights.agent.internal.model.AuxThreadRootSpanImpl;
import com.microsoft.applicationinsights.agent.internal.model.Global;
import com.microsoft.applicationinsights.agent.internal.model.ThreadContextImpl;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBinding;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.instrumentation.engine.impl.NopTransactionService;

class AuxThreadContextImpl<T>
implements AuxThreadContext {
    private final SdkBinding<T> sdkBinding;
    @Nullable
    private final ThreadContext.ServletRequestInfo servletRequestInfo;

    public AuxThreadContextImpl(SdkBinding<T> sdkBinding, @Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
        this.sdkBinding = sdkBinding;
        this.servletRequestInfo = servletRequestInfo;
    }

    @Override
    public Span start() {
        return this.start(false);
    }

    @Override
    public Span startAndMarkAsyncTransactionComplete() {
        return this.start(true);
    }

    private Span start(boolean completeAsyncTransaction) {
        ThreadContextThreadLocal.Holder threadContextHolder = Global.getThreadContextHolder();
        ThreadContextImpl<T> threadContext = threadContextHolder.get();
        if (threadContext != null && threadContext.getServletRequestInfo() == this.servletRequestInfo) {
            if (completeAsyncTransaction) {
                threadContext.setTransactionAsyncComplete();
            }
            return NopTransactionService.LOCAL_SPAN;
        }
        threadContext = new ThreadContextImpl<T>(this.sdkBinding, this.servletRequestInfo, 0, 0);
        threadContextHolder.set(threadContext);
        if (completeAsyncTransaction) {
            threadContext.setTransactionAsyncComplete();
        }
        this.sdkBinding.addAuxThreadContextHolder(threadContextHolder);
        this.sdkBinding.bindRequestTelemetryContext();
        return new AuxThreadRootSpanImpl(this.sdkBinding, threadContextHolder);
    }
}

