/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.model;

import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import java.util.Map;
import org.glowroot.instrumentation.api.Getter;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.engine.impl.NopTransactionService;

public class QuerySpanImpl
implements QuerySpan {
    private final SdkBridge sdkBridge;
    private final String type;
    private final String dest;
    private final String text;
    private final long startTimeMillis;
    private final QueryMessageSupplier messageSupplier;
    @MonotonicNonNull
    private volatile Throwable exception;
    private volatile long totalMillis = -1L;

    QuerySpanImpl(SdkBridge sdkBridge, String type, String dest, String text, long startTimeMillis, QueryMessageSupplier messageSupplier) {
        this.sdkBridge = sdkBridge;
        this.type = type;
        this.dest = dest;
        this.text = text;
        this.startTimeMillis = startTimeMillis;
        this.messageSupplier = messageSupplier;
    }

    @Override
    public void rowNavigationAttempted() {
    }

    @Override
    public void incrementCurrRow() {
    }

    @Override
    public void setCurrRow(long row) {
    }

    @Override
    public void end() {
        this.endInternal();
    }

    @Override
    public void endWithLocationStackTrace(long thresholdNanos) {
        this.endInternal();
    }

    @Override
    public void endWithError(Throwable t) {
        this.exception = t;
        this.endInternal();
    }

    @Override
    public long partOneEnd() {
        return this.endInternalPart1();
    }

    @Override
    public long partOneEndWithLocationStackTrace(long thresholdNanos) {
        return this.endInternalPart1();
    }

    @Override
    public void partTwoEnd() {
        this.endInternalPart2();
    }

    @Override
    public Timer extend() {
        return NopTransactionService.TIMER;
    }

    @Override
    public QueryMessageSupplier getMessageSupplier() {
        return this.messageSupplier;
    }

    @Override
    @Deprecated
    public <R> void propagateToResponse(R response, Setter<R> setter) {
    }

    @Override
    @Deprecated
    public <R> void extractFromResponse(R response, Getter<R> getter) {
    }

    private void endInternal() {
        this.endInternalPart1();
        this.endInternalPart2();
    }

    private long endInternalPart1() {
        this.totalMillis = System.currentTimeMillis() - this.startTimeMillis;
        return this.totalMillis;
    }

    private void endInternalPart2() {
        Object explainPlan;
        Boolean batchStatement;
        if (!this.type.equals("SQL") && !this.type.equals("MongoDB")) {
            return;
        }
        SdkBridge.RemoteDependencyTelemetry telemetry = new SdkBridge.RemoteDependencyTelemetry(this.startTimeMillis, this.totalMillis, this.type, this.exception == null);
        if (this.dest.isEmpty()) {
            telemetry.setName(this.type);
        } else {
            telemetry.setName(this.dest);
        }
        telemetry.setCommandName(this.text);
        Map<String, ?> detail = this.messageSupplier.get();
        Integer batchCount = (Integer)detail.get("batchCount");
        if (batchCount != null) {
            telemetry.getProperties().put("Args", " [Batch of " + batchCount + "]");
        }
        if ((batchStatement = (Boolean)detail.get("batchStatement")) != null) {
            telemetry.getProperties().put("Args", " [Batch]");
        }
        if ((explainPlan = detail.get("explainPlan")) instanceof String) {
            telemetry.getProperties().put("Query Plan", (String)explainPlan);
        } else if (explainPlan instanceof Map) {
            Map map = (Map)explainPlan;
            StringBuilder sb = new StringBuilder();
            boolean needsSeparator = false;
            for (Map.Entry entry : map.entrySet()) {
                if (needsSeparator) {
                    sb.append(',');
                }
                sb.append(entry.getKey());
                sb.append(':');
                sb.append(entry.getValue());
                needsSeparator = true;
            }
            telemetry.getProperties().put("Query Plan", sb.toString());
        }
        this.sdkBridge.track(telemetry);
        if (this.exception != null) {
            this.sdkBridge.track(new SdkBridge.ExceptionTelemetry(this.exception));
        }
    }
}

