/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.model;

import com.microsoft.applicationinsights.agent.internal.model.AsyncOutgoingSpanImpl;
import com.microsoft.applicationinsights.agent.internal.model.AsyncQuerySpanImpl;
import com.microsoft.applicationinsights.agent.internal.model.AuxThreadContextImpl;
import com.microsoft.applicationinsights.agent.internal.model.Global;
import com.microsoft.applicationinsights.agent.internal.model.LocalSpanImpl;
import com.microsoft.applicationinsights.agent.internal.model.LoggerSpans;
import com.microsoft.applicationinsights.agent.internal.model.OutgoingSpanImpl;
import com.microsoft.applicationinsights.agent.internal.model.QuerySpanImpl;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBinding;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.concurrent.TimeUnit;
import org.glowroot.instrumentation.api.AsyncQuerySpan;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Getter;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.internal.ReadableMessage;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextPlus;
import org.glowroot.instrumentation.engine.impl.NopTransactionService;

public class ThreadContextImpl<T>
implements ThreadContextPlus {
    private final SdkBinding<T> sdkBinding;
    @Nullable
    private final ThreadContext.ServletRequestInfo servletRequestInfo;
    private int currentNestingGroupId;
    private int currentSuppressionKeyId;

    public ThreadContextImpl(SdkBinding<T> sdkBinding, @Nullable ThreadContext.ServletRequestInfo servletRequestInfo, int rootNestingGroupId, int rootSuppressionKeyId) {
        this.sdkBinding = sdkBinding;
        this.servletRequestInfo = servletRequestInfo;
        this.currentNestingGroupId = rootNestingGroupId;
        this.currentSuppressionKeyId = rootSuppressionKeyId;
    }

    @Override
    public boolean isInTransaction() {
        return true;
    }

    @Override
    public <C> Span startIncomingSpan(String transactionType, String transactionName, Getter<C> getter, C carrier, MessageSupplier messageSupplier, TimerName timerName, OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior) {
        return NopTransactionService.LOCAL_SPAN;
    }

    @Override
    public Span startLocalSpan(MessageSupplier messageSupplier, TimerName timerName) {
        String text = ((ReadableMessage)((Object)messageSupplier.get())).getText();
        if (text.startsWith("__custom,")) {
            return new LocalSpanImpl(this.sdkBinding.getSdkBridge(), text, System.currentTimeMillis(), messageSupplier);
        }
        return NopTransactionService.LOCAL_SPAN;
    }

    @Override
    public QuerySpan startQuerySpan(String type, String dest, String text, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        return new QuerySpanImpl(this.sdkBinding.getSdkBridge(), type, dest, text, System.currentTimeMillis(), queryMessageSupplier);
    }

    @Override
    public QuerySpan startQuerySpan(String type, String dest, String text, long queryExecutionCount, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        return new QuerySpanImpl(this.sdkBinding.getSdkBridge(), type, dest, text, System.currentTimeMillis(), queryMessageSupplier);
    }

    @Override
    public AsyncQuerySpan startAsyncQuerySpan(String type, String dest, String text, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        return new AsyncQuerySpanImpl(this.sdkBinding.getSdkBridge(), type, dest, text, System.currentTimeMillis(), queryMessageSupplier);
    }

    @Override
    public <C> Span startOutgoingSpan(String type, String text, Setter<C> setter, C carrier, MessageSupplier messageSupplier, TimerName timerName) {
        SdkBridge<T> sdkBridge = this.sdkBinding.getSdkBridge();
        String outgoingSpanId = sdkBridge.propagate(new SdkBridge.Setter<C>(setter), carrier, Global.isOutboundW3CEnabled(), Global.isOutboundW3CBackCompatEnabled());
        return new OutgoingSpanImpl(sdkBridge, type, text, System.currentTimeMillis(), outgoingSpanId, messageSupplier);
    }

    @Override
    public <C> AsyncSpan startAsyncOutgoingSpan(String type, String text, Setter<C> setter, C carrier, MessageSupplier messageSupplier, TimerName timerName) {
        SdkBridge<T> sdkBridge = this.sdkBinding.getSdkBridge();
        String outgoingSpanId = sdkBridge.propagate(new SdkBridge.Setter<C>(setter), carrier, Global.isOutboundW3CEnabled(), Global.isOutboundW3CBackCompatEnabled());
        return new AsyncOutgoingSpanImpl(sdkBridge, type, text, System.currentTimeMillis(), outgoingSpanId, messageSupplier);
    }

    @Override
    public void captureLoggerSpan(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        LoggerSpans.track(this.sdkBinding.getSdkBridge(), messageSupplier, throwable, System.currentTimeMillis());
    }

    @Override
    public Timer startTimer(TimerName timerName) {
        return NopTransactionService.TIMER;
    }

    @Override
    public AuxThreadContext createAuxThreadContext() {
        return new AuxThreadContextImpl<T>(this.sdkBinding, this.servletRequestInfo);
    }

    @Override
    public void setTransactionAsync() {
    }

    @Override
    public void setTransactionAsyncComplete() {
    }

    @Override
    public void setTransactionType(@Nullable String transactionType, int priority) {
    }

    @Override
    public void setTransactionName(@Nullable String transactionName, int priority) {
        if (transactionName != null) {
            this.sdkBinding.setOperationName(transactionName);
        }
    }

    @Override
    public void setTransactionUser(@Nullable String user, int priority) {
    }

    @Override
    public void addTransactionAttribute(String name, @Nullable String value) {
    }

    @Override
    public void setTransactionSlowThreshold(long threshold, TimeUnit unit, int priority) {
    }

    @Override
    public void setTransactionError(Throwable t) {
    }

    @Override
    public void setTransactionError(@Nullable String message) {
    }

    @Override
    public void setTransactionError(@Nullable String message, @Nullable Throwable t) {
    }

    @Override
    public void trackResourceAcquired(Object resource, boolean withLocationStackTrace) {
    }

    @Override
    public void trackResourceReleased(Object resource) {
    }

    @Override
    @Nullable
    public ThreadContext.ServletRequestInfo getServletRequestInfo() {
        return this.servletRequestInfo;
    }

    @Override
    public void setServletRequestInfo(ThreadContext.ServletRequestInfo servletRequestInfo) {
    }

    @Override
    public int getCurrentNestingGroupId() {
        return this.currentNestingGroupId;
    }

    @Override
    public void setCurrentNestingGroupId(int nestingGroupId) {
        this.currentNestingGroupId = nestingGroupId;
    }

    @Override
    public int getCurrentSuppressionKeyId() {
        return this.currentSuppressionKeyId;
    }

    @Override
    public void setCurrentSuppressionKeyId(int suppressionKeyId) {
        this.currentSuppressionKeyId = suppressionKeyId;
    }
}

