/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.sdk;

import com.microsoft.applicationinsights.agent.internal.model.Global;
import com.microsoft.applicationinsights.agent.internal.sdk.BindingResult;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Set;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextThreadLocal;

public class SdkBinding<T>
implements BindingResult {
    private final SdkBridge<T> sdkBridge;
    @Nullable
    private final T requestTelemetryContext;
    private final Set<ThreadContextThreadLocal.Holder> auxThreadContextHolders = Sets.newHashSet();

    SdkBinding(SdkBridge<T> sdkBridge, @Nullable T requestTelemetryContext) {
        this.sdkBridge = sdkBridge;
        this.requestTelemetryContext = requestTelemetryContext;
    }

    public SdkBridge<T> getSdkBridge() {
        return this.sdkBridge;
    }

    public void bindRequestTelemetryContext() {
        if (this.requestTelemetryContext != null) {
            this.sdkBridge.bindRequestTelemetryContext(this.requestTelemetryContext);
        }
    }

    public void unbindRequestTelemetryContext() {
        this.sdkBridge.unbindRequestTelemetryContext();
    }

    public void setOperationName(String operationName) {
        if (this.requestTelemetryContext != null) {
            this.sdkBridge.setOperationName(this.requestTelemetryContext, operationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuxThreadContextHolder(ThreadContextThreadLocal.Holder auxThreadContextHolder) {
        Set<ThreadContextThreadLocal.Holder> set = this.auxThreadContextHolders;
        synchronized (set) {
            this.auxThreadContextHolders.add(auxThreadContextHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAuxThreadContextHolder(ThreadContextThreadLocal.Holder auxThreadContextHolder) {
        Set<ThreadContextThreadLocal.Holder> set = this.auxThreadContextHolders;
        synchronized (set) {
            this.auxThreadContextHolders.remove(auxThreadContextHolder);
        }
    }

    @Override
    public void unbindFromMainThread() {
        Global.getThreadContextHolder().set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFromRunawayChildThreads() {
        Set<ThreadContextThreadLocal.Holder> set = this.auxThreadContextHolders;
        synchronized (set) {
            for (ThreadContextThreadLocal.Holder auxThreadContextHolder : this.auxThreadContextHolders) {
                auxThreadContextHolder.set(null);
            }
        }
    }
}

