/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.sdk;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.HashMap;
import java.util.Map;

public interface SdkBridge<T> {
    public void bindRequestTelemetryContext(T var1);

    public void unbindRequestTelemetryContext();

    public void setOperationName(T var1, String var2);

    public String generateChildDependencyTarget(String var1, boolean var2);

    public <C> String propagate(Setter<C> var1, C var2, boolean var3, boolean var4);

    public void track(RemoteDependencyTelemetry var1);

    public void track(TraceTelemetry var1);

    public void track(ExceptionTelemetry var1);

    public static class RemoteDependencyTelemetry {
        private final long timestamp;
        private final long durationMillis;
        private final String type;
        private final boolean success;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String commandName;
        @Nullable
        private String target;
        @Nullable
        private String resultCode;
        private final Map<String, String> properties = new HashMap<String, String>();

        public RemoteDependencyTelemetry(long timestamp, long durationMillis, String type, boolean success) {
            this.timestamp = timestamp;
            this.durationMillis = durationMillis;
            this.type = type;
            this.success = success;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getDurationMillis() {
            return this.durationMillis;
        }

        public String getType() {
            return this.type;
        }

        public boolean isSuccess() {
            return this.success;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public void setId(@Nullable String id) {
            this.id = id;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Nullable
        public String getCommandName() {
            return this.commandName;
        }

        public void setCommandName(String commandName) {
            this.commandName = commandName;
        }

        @Nullable
        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        @Nullable
        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    public static class ExceptionTelemetry {
        private final Throwable throwable;
        @Nullable
        private final String level;
        private final Map<String, String> properties = new HashMap<String, String>();

        public ExceptionTelemetry(Throwable throwable) {
            this(throwable, null);
        }

        public ExceptionTelemetry(Throwable throwable, @Nullable String level) {
            this.throwable = throwable;
            this.level = level;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        @Nullable
        public String getLevel() {
            return this.level;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    public static class TraceTelemetry {
        private final String message;
        @Nullable
        private final String level;
        private final Map<String, String> properties = new HashMap<String, String>();

        public TraceTelemetry(String message, @Nullable String level) {
            this.message = message;
            this.level = level;
        }

        public String getMessage() {
            return this.message;
        }

        @Nullable
        public String getLevel() {
            return this.level;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    public static class Setter<C>
    implements org.glowroot.instrumentation.api.Setter<C> {
        private final org.glowroot.instrumentation.api.Setter<C> setter;

        public Setter(org.glowroot.instrumentation.api.Setter<C> setter) {
            this.setter = setter;
        }

        @Override
        public void put(C carrier, String key, String value) {
            this.setter.put(carrier, key, value);
        }
    }
}

