/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.checker.PolyNull;
import org.glowroot.instrumentation.api.internal.ReadableMessage;

public abstract class Message {
    private static final int MESSAGE_CHAR_LIMIT = 100000;
    private static final int MESSAGE_DETAIL_CHAR_LIMIT = 10000;
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Map<String, Object> EMPTY_DETAIL = Collections.emptyMap();

    public static Message create(@Nullable String message) {
        return new MessageImpl(message, EMPTY_ARGS, EMPTY_DETAIL);
    }

    public static Message create(String template, String ... args) {
        return new MessageImpl(template, args, EMPTY_DETAIL);
    }

    public static Message create(@Nullable String message, Map<String, ?> detail) {
        return new MessageImpl(message, EMPTY_ARGS, detail);
    }

    Message() {
    }

    private static class MessageImpl
    extends Message
    implements ReadableMessage {
        private static final Logger logger = Logger.getLogger(MessageImpl.class);
        @Nullable
        private final String template;
        @Nullable
        private final String[] args;
        private final Map<String, ?> detail;

        private MessageImpl(@Nullable String template, @Nullable String[] args, Map<String, ?> detail) {
            this.template = MessageImpl.truncateMessageIfNeeded(template);
            for (int i = 0; i < args.length; ++i) {
                args[i] = MessageImpl.truncateMessageIfNeeded(args[i]);
            }
            this.args = args;
            this.detail = MessageImpl.needsTruncateDetail(detail) ? MessageImpl.truncateDetail(detail) : detail;
        }

        @Override
        public String getText() {
            int next;
            if (this.template == null) {
                return "";
            }
            if (this.args.length == 0) {
                return this.template;
            }
            StringBuilder text = new StringBuilder();
            int curr = 0;
            int argIndex = 0;
            while ((next = this.template.indexOf("{}", curr)) != -1) {
                text.append(this.template.substring(curr, next));
                if (argIndex < this.args.length) {
                    text.append(this.args[argIndex++]);
                    curr = next + 2;
                    continue;
                }
                text.append("<not enough args provided for template>");
                curr = next + 2;
                logger.warn("not enough args provided for template: {}", (Object)this.template);
            }
            text.append(this.template.substring(curr));
            return MessageImpl.truncateMessageIfNeeded(text.toString());
        }

        @Override
        public Map<String, ?> getDetail() {
            return this.detail;
        }

        @PolyNull
        private static String truncateMessageIfNeeded(@PolyNull String s) {
            if (s == null || s.length() <= 100000) {
                return s;
            }
            return s.substring(0, 100000) + " [truncated to " + 100000 + " characters]";
        }

        private static boolean needsTruncateDetail(Map<?, ?> detail) {
            for (Map.Entry<?, ?> entry : detail.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String && MessageImpl.needsTruncateDetail((String)key)) {
                    return true;
                }
                if (!MessageImpl.needsTruncateDetail(entry.getValue())) continue;
                return true;
            }
            return false;
        }

        private static boolean needsTruncateDetail(@Nullable Object value) {
            if (value instanceof Map) {
                return MessageImpl.needsTruncateDetail((Map)value);
            }
            if (value instanceof List) {
                return MessageImpl.needsTruncateDetail((List)value);
            }
            if (value instanceof String) {
                return MessageImpl.needsTruncateDetail((String)value);
            }
            return false;
        }

        private static boolean needsTruncateDetail(List<?> detail) {
            for (Object value : detail) {
                if (!MessageImpl.needsTruncateDetail(value)) continue;
                return true;
            }
            return false;
        }

        private static boolean needsTruncateDetail(String value) {
            return value.length() > 10000;
        }

        private static Map<String, ?> truncateDetail(Map<String, ?> detail) {
            HashMap<String, Object> truncatedDetail = new HashMap<String, Object>();
            for (Map.Entry<String, ?> entry : detail.entrySet()) {
                truncatedDetail.put(MessageImpl.truncateDetailIfNeeded(entry.getKey()), MessageImpl.truncate(entry.getValue()));
            }
            return truncatedDetail;
        }

        @Nullable
        private static Object truncate(@Nullable Object value) {
            if (value instanceof Map) {
                return MessageImpl.truncateDetailNested((Map)value);
            }
            if (value instanceof List) {
                return MessageImpl.truncateDetail((List)value);
            }
            if (value instanceof String) {
                return MessageImpl.truncateDetailIfNeeded((String)value);
            }
            return value;
        }

        private static Map<?, ?> truncateDetailNested(Map<?, ?> detail) {
            HashMap truncatedDetail = new HashMap();
            for (Map.Entry<?, ?> entry : detail.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    key = MessageImpl.truncateDetailIfNeeded((String)key);
                }
                truncatedDetail.put(key, MessageImpl.truncate(entry.getValue()));
            }
            return truncatedDetail;
        }

        private static List<Object> truncateDetail(List<?> detail) {
            ArrayList<Object> truncatedDetail = new ArrayList<Object>();
            for (Object value : detail) {
                truncatedDetail.add(MessageImpl.truncate(value));
            }
            return truncatedDetail;
        }

        private static String truncateDetailIfNeeded(String s) {
            if (s.length() <= 10000) {
                return s;
            }
            return s.substring(0, 10000) + " [truncated to " + 10000 + " characters]";
        }
    }
}

