/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.api.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.checker.Nullable;

public class Reflection {
    private static final Logger logger = Logger.getLogger(Reflection.class);

    private Reflection() {
    }

    @Nullable
    public static Class<?> getClass(String name, @Nullable ClassLoader loader) {
        return Reflection.getClass(name, loader, false);
    }

    @Nullable
    public static Class<?> getClassWithWarnIfNotFound(String name, @Nullable ClassLoader loader) {
        return Reflection.getClass(name, loader, true);
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
            return null;
        }
    }

    @Nullable
    public static Field getDeclaredField(@Nullable Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            logger.debug(e.getMessage(), e);
            return null;
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
            return null;
        }
    }

    public static <T> T invoke(@Nullable Method method, Object obj, Object ... args) {
        if (method == null) {
            return null;
        }
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Throwable t) {
            logger.warn("error calling {}.{}()", method.getDeclaringClass().getName(), method.getName(), t);
            return null;
        }
    }

    public static <T> T invokeWithDefault(@Nullable Method method, Object obj, T defaultValue, Object ... args) {
        if (method == null) {
            return defaultValue;
        }
        try {
            Object value = method.invoke(obj, args);
            if (value == null) {
                return defaultValue;
            }
            return (T)value;
        }
        catch (Throwable t) {
            logger.warn("error calling {}.{}()", method.getDeclaringClass().getName(), method.getName(), t);
            return defaultValue;
        }
    }

    @Nullable
    public static Object getFieldValue(@Nullable Field field, Object obj) {
        if (field == null) {
            return null;
        }
        try {
            return field.get(obj);
        }
        catch (Throwable t) {
            logger.warn("error getting {}.{}()", field.getDeclaringClass().getName(), field.getName(), t);
            return null;
        }
    }

    @Nullable
    private static Class<?> getClass(String name, @Nullable ClassLoader loader, boolean warnIfNotFound) {
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException e) {
            if (warnIfNotFound) {
                logger.warn(e.getMessage(), e);
            } else {
                logger.debug(e.getMessage(), e);
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        return null;
    }
}

