/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapter;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonWriter;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public class DefaultValue {
    @Nullable
    private final Object value;

    DefaultValue(@Nullable Object value) {
        this.value = value;
    }

    @Nullable
    public Object value() {
        return this.value;
    }

    static class PropertyValueTypeAdapter
    extends TypeAdapter<DefaultValue> {
        PropertyValueTypeAdapter() {
        }

        @Override
        public DefaultValue read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            switch (token) {
                case BOOLEAN: {
                    return new DefaultValue(in.nextBoolean());
                }
                case NUMBER: {
                    return new DefaultValue(in.nextDouble());
                }
                case STRING: {
                    return new DefaultValue(in.nextString());
                }
                case BEGIN_ARRAY: {
                    ArrayList<String> list = Lists.newArrayList();
                    in.beginArray();
                    while (in.peek() != JsonToken.END_ARRAY) {
                        list.add(in.nextString());
                    }
                    in.endArray();
                    return new DefaultValue(list);
                }
            }
            throw new AssertionError((Object)("Unexpected json type: " + (Object)((Object)token)));
        }

        @Override
        public void write(JsonWriter out, DefaultValue value) {
            throw new UnsupportedOperationException("This should not be needed");
        }
    }

    public static enum PropertyType {
        STRING,
        BOOLEAN,
        DOUBLE,
        LIST;

    }
}

