/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.Gson;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapter;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapterFactory;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.reflect.TypeToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig;
import org.immutables.value.Generated;

@Generated(from="org.glowroot.instrumentation.engine.config", generator="Gsons")
public final class GsonAdaptersAdviceConfig
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (AdviceConfigTypeAdapter.adapts(type)) {
            return new AdviceConfigTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersAdviceConfig(AdviceConfig)";
    }

    @Generated(from="AdviceConfig", generator="Gsons")
    private static class AdviceConfigTypeAdapter
    extends TypeAdapter<AdviceConfig> {
        public final AdviceConfig.MethodModifier methodModifiersTypeSample = null;
        public final AdviceConfig.CaptureKind captureKindTypeSample = null;
        public final Integer transactionSlowThresholdMillisTypeSample = null;
        public final AdviceConfig.AlreadyInTransactionBehavior alreadyInTransactionBehaviorTypeSample = null;
        public final Integer spanStackThresholdMillisTypeSample = null;
        private final TypeAdapter<AdviceConfig.MethodModifier> methodModifiersTypeAdapter;
        private final TypeAdapter<AdviceConfig.CaptureKind> captureKindTypeAdapter;
        private final TypeAdapter<Integer> transactionSlowThresholdMillisTypeAdapter;
        private final TypeAdapter<AdviceConfig.AlreadyInTransactionBehavior> alreadyInTransactionBehaviorTypeAdapter;
        private final TypeAdapter<Integer> spanStackThresholdMillisTypeAdapter;

        AdviceConfigTypeAdapter(Gson gson) {
            this.methodModifiersTypeAdapter = gson.getAdapter(AdviceConfig.MethodModifier.class);
            this.captureKindTypeAdapter = gson.getAdapter(AdviceConfig.CaptureKind.class);
            this.transactionSlowThresholdMillisTypeAdapter = gson.getAdapter(Integer.class);
            this.alreadyInTransactionBehaviorTypeAdapter = gson.getAdapter(AdviceConfig.AlreadyInTransactionBehavior.class);
            this.spanStackThresholdMillisTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return AdviceConfig.class == type.getRawType() || ImmutableAdviceConfig.class == type.getRawType();
        }

        @Override
        public void write(JsonWriter out, AdviceConfig value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeAdviceConfig(out, value);
            }
        }

        @Override
        public AdviceConfig read(JsonReader in) throws IOException {
            return this.readAdviceConfig(in);
        }

        private void writeAdviceConfig(JsonWriter out, AdviceConfig instance) throws IOException {
            out.beginObject();
            out.name("className");
            out.value(instance.className());
            out.name("classAnnotation");
            out.value(instance.classAnnotation());
            out.name("subTypeRestriction");
            out.value(instance.subTypeRestriction());
            out.name("superTypeRestriction");
            out.value(instance.superTypeRestriction());
            out.name("methodDeclaringClassName");
            out.value(instance.methodDeclaringClassName());
            out.name("methodName");
            out.value(instance.methodName());
            out.name("methodAnnotation");
            out.value(instance.methodAnnotation());
            ImmutableList<String> methodParameterTypesElements = instance.methodParameterTypes();
            out.name("methodParameterTypes");
            out.beginArray();
            for (String string : methodParameterTypesElements) {
                out.value(string);
            }
            out.endArray();
            out.name("methodReturnType");
            out.value(instance.methodReturnType());
            ImmutableList<AdviceConfig.MethodModifier> methodModifiersElements = instance.methodModifiers();
            out.name("methodModifiers");
            out.beginArray();
            for (AdviceConfig.MethodModifier methodModifier : methodModifiersElements) {
                this.methodModifiersTypeAdapter.write(out, methodModifier);
            }
            out.endArray();
            out.name("nestingGroup");
            out.value(instance.nestingGroup());
            out.name("order");
            out.value(instance.order());
            out.name("captureKind");
            this.captureKindTypeAdapter.write(out, instance.captureKind());
            out.name("transactionType");
            out.value(instance.transactionType());
            out.name("transactionNameTemplate");
            out.value(instance.transactionNameTemplate());
            out.name("transactionUserTemplate");
            out.value(instance.transactionUserTemplate());
            Map<String, String> map = instance.transactionAttributeTemplates();
            out.name("transactionAttributeTemplates");
            out.beginObject();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                out.name(key);
                String value = entry.getValue();
                out.value(value);
            }
            out.endObject();
            Integer n = instance.transactionSlowThresholdMillis();
            if (n != null) {
                out.name("transactionSlowThresholdMillis");
                this.transactionSlowThresholdMillisTypeAdapter.write(out, n);
            } else if (out.getSerializeNulls()) {
                out.name("transactionSlowThresholdMillis");
                out.nullValue();
            }
            AdviceConfig.AlreadyInTransactionBehavior alreadyInTransactionBehavior = instance.alreadyInTransactionBehavior();
            if (alreadyInTransactionBehavior != null) {
                out.name("alreadyInTransactionBehavior");
                this.alreadyInTransactionBehaviorTypeAdapter.write(out, alreadyInTransactionBehavior);
            } else if (out.getSerializeNulls()) {
                out.name("alreadyInTransactionBehavior");
                out.nullValue();
            }
            out.name("spanMessageTemplate");
            out.value(instance.spanMessageTemplate());
            Integer spanStackThresholdMillisValue = instance.spanStackThresholdMillis();
            if (spanStackThresholdMillisValue != null) {
                out.name("spanStackThresholdMillis");
                this.spanStackThresholdMillisTypeAdapter.write(out, spanStackThresholdMillisValue);
            } else if (out.getSerializeNulls()) {
                out.name("spanStackThresholdMillis");
                out.nullValue();
            }
            out.name("spanCaptureSelfNested");
            out.value(instance.spanCaptureSelfNested());
            out.name("timerName");
            out.value(instance.timerName());
            out.name("enabledProperty");
            out.value(instance.enabledProperty());
            out.name("localSpanEnabledProperty");
            out.value(instance.localSpanEnabledProperty());
            out.endObject();
        }

        private AdviceConfig readAdviceConfig(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableAdviceConfig.Builder builder = ImmutableAdviceConfig.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'c': {
                    if ("className".equals(attributeName)) {
                        this.readInClassName(in, builder);
                        return;
                    }
                    if ("classAnnotation".equals(attributeName)) {
                        this.readInClassAnnotation(in, builder);
                        return;
                    }
                    if (!"captureKind".equals(attributeName)) break;
                    this.readInCaptureKind(in, builder);
                    return;
                }
                case 's': {
                    if ("subTypeRestriction".equals(attributeName)) {
                        this.readInSubTypeRestriction(in, builder);
                        return;
                    }
                    if ("superTypeRestriction".equals(attributeName)) {
                        this.readInSuperTypeRestriction(in, builder);
                        return;
                    }
                    if ("spanMessageTemplate".equals(attributeName)) {
                        this.readInSpanMessageTemplate(in, builder);
                        return;
                    }
                    if ("spanStackThresholdMillis".equals(attributeName)) {
                        this.readInSpanStackThresholdMillis(in, builder);
                        return;
                    }
                    if (!"spanCaptureSelfNested".equals(attributeName)) break;
                    this.readInSpanCaptureSelfNested(in, builder);
                    return;
                }
                case 'm': {
                    if ("methodDeclaringClassName".equals(attributeName)) {
                        this.readInMethodDeclaringClassName(in, builder);
                        return;
                    }
                    if ("methodName".equals(attributeName)) {
                        this.readInMethodName(in, builder);
                        return;
                    }
                    if ("methodAnnotation".equals(attributeName)) {
                        this.readInMethodAnnotation(in, builder);
                        return;
                    }
                    if ("methodParameterTypes".equals(attributeName)) {
                        this.readInMethodParameterTypes(in, builder);
                        return;
                    }
                    if ("methodReturnType".equals(attributeName)) {
                        this.readInMethodReturnType(in, builder);
                        return;
                    }
                    if (!"methodModifiers".equals(attributeName)) break;
                    this.readInMethodModifiers(in, builder);
                    return;
                }
                case 'n': {
                    if (!"nestingGroup".equals(attributeName)) break;
                    this.readInNestingGroup(in, builder);
                    return;
                }
                case 'o': {
                    if (!"order".equals(attributeName)) break;
                    this.readInOrder(in, builder);
                    return;
                }
                case 't': {
                    if ("transactionType".equals(attributeName)) {
                        this.readInTransactionType(in, builder);
                        return;
                    }
                    if ("transactionNameTemplate".equals(attributeName)) {
                        this.readInTransactionNameTemplate(in, builder);
                        return;
                    }
                    if ("transactionUserTemplate".equals(attributeName)) {
                        this.readInTransactionUserTemplate(in, builder);
                        return;
                    }
                    if ("transactionAttributeTemplates".equals(attributeName)) {
                        this.readInTransactionAttributeTemplates(in, builder);
                        return;
                    }
                    if ("transactionSlowThresholdMillis".equals(attributeName)) {
                        this.readInTransactionSlowThresholdMillis(in, builder);
                        return;
                    }
                    if (!"timerName".equals(attributeName)) break;
                    this.readInTimerName(in, builder);
                    return;
                }
                case 'a': {
                    if (!"alreadyInTransactionBehavior".equals(attributeName)) break;
                    this.readInAlreadyInTransactionBehavior(in, builder);
                    return;
                }
                case 'e': {
                    if (!"enabledProperty".equals(attributeName)) break;
                    this.readInEnabledProperty(in, builder);
                    return;
                }
                case 'l': {
                    if (!"localSpanEnabledProperty".equals(attributeName)) break;
                    this.readInLocalSpanEnabledProperty(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInClassName(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.className(in.nextString());
        }

        private void readInClassAnnotation(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.classAnnotation(in.nextString());
        }

        private void readInSubTypeRestriction(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.subTypeRestriction(in.nextString());
        }

        private void readInSuperTypeRestriction(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.superTypeRestriction(in.nextString());
        }

        private void readInMethodDeclaringClassName(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.methodDeclaringClassName(in.nextString());
        }

        private void readInMethodName(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.methodName(in.nextString());
        }

        private void readInMethodAnnotation(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.methodAnnotation(in.nextString());
        }

        private void readInMethodParameterTypes(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addMethodParameterTypes(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addMethodParameterTypes(in.nextString());
            }
        }

        private void readInMethodReturnType(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.methodReturnType(in.nextString());
        }

        private void readInMethodModifiers(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    AdviceConfig.MethodModifier value = this.methodModifiersTypeAdapter.read(in);
                    builder.addMethodModifiers(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                AdviceConfig.MethodModifier value = this.methodModifiersTypeAdapter.read(in);
                builder.addMethodModifiers(value);
            }
        }

        private void readInNestingGroup(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.nestingGroup(in.nextString());
        }

        private void readInOrder(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.order(in.nextInt());
        }

        private void readInCaptureKind(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            AdviceConfig.CaptureKind value = this.captureKindTypeAdapter.read(in);
            builder.captureKind(value);
        }

        private void readInTransactionType(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.transactionType(in.nextString());
        }

        private void readInTransactionNameTemplate(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.transactionNameTemplate(in.nextString());
        }

        private void readInTransactionUserTemplate(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.transactionUserTemplate(in.nextString());
        }

        private void readInTransactionAttributeTemplates(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putTransactionAttributeTemplates(key, value);
                }
                in.endObject();
            }
        }

        private void readInTransactionSlowThresholdMillis(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = this.transactionSlowThresholdMillisTypeAdapter.read(in);
                builder.transactionSlowThresholdMillis(value);
            }
        }

        private void readInAlreadyInTransactionBehavior(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                AdviceConfig.AlreadyInTransactionBehavior value = this.alreadyInTransactionBehaviorTypeAdapter.read(in);
                builder.alreadyInTransactionBehavior(value);
            }
        }

        private void readInSpanMessageTemplate(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.spanMessageTemplate(in.nextString());
        }

        private void readInSpanStackThresholdMillis(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = this.spanStackThresholdMillisTypeAdapter.read(in);
                builder.spanStackThresholdMillis(value);
            }
        }

        private void readInSpanCaptureSelfNested(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.spanCaptureSelfNested(in.nextBoolean());
        }

        private void readInTimerName(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.timerName(in.nextString());
        }

        private void readInEnabledProperty(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.enabledProperty(in.nextString());
        }

        private void readInLocalSpanEnabledProperty(JsonReader in, ImmutableAdviceConfig.Builder builder) throws IOException {
            builder.localSpanEnabledProperty(in.nextString());
        }
    }
}

