/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.Gson;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapter;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapterFactory;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.reflect.TypeToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.ImmutableInstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.PropertyDescriptor;
import org.immutables.value.Generated;

@Generated(from="org.glowroot.instrumentation.engine.config", generator="Gsons")
public final class GsonAdaptersInstrumentationDescriptor
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (InstrumentationDescriptorTypeAdapter.adapts(type)) {
            return new InstrumentationDescriptorTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersInstrumentationDescriptor(InstrumentationDescriptor)";
    }

    @Generated(from="InstrumentationDescriptor", generator="Gsons")
    private static class InstrumentationDescriptorTypeAdapter
    extends TypeAdapter<InstrumentationDescriptor> {
        public final PropertyDescriptor propertiesTypeSample = null;
        public final AdviceConfig adviceConfigsTypeSample = null;
        private final TypeAdapter<PropertyDescriptor> propertiesTypeAdapter;
        private final TypeAdapter<AdviceConfig> adviceConfigsTypeAdapter;

        InstrumentationDescriptorTypeAdapter(Gson gson) {
            this.propertiesTypeAdapter = gson.getAdapter(PropertyDescriptor.class);
            this.adviceConfigsTypeAdapter = gson.getAdapter(AdviceConfig.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return InstrumentationDescriptor.class == type.getRawType() || ImmutableInstrumentationDescriptor.class == type.getRawType();
        }

        @Override
        public void write(JsonWriter out, InstrumentationDescriptor value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeInstrumentationDescriptor(out, value);
            }
        }

        @Override
        public InstrumentationDescriptor read(JsonReader in) throws IOException {
            return this.readInstrumentationDescriptor(in);
        }

        private void writeInstrumentationDescriptor(JsonWriter out, InstrumentationDescriptor instance) throws IOException {
            out.beginObject();
            out.name("id");
            out.value(instance.id());
            out.name("name");
            out.value(instance.name());
            ImmutableList<PropertyDescriptor> propertiesElements = instance.properties();
            out.name("properties");
            out.beginArray();
            for (PropertyDescriptor propertyDescriptor : propertiesElements) {
                this.propertiesTypeAdapter.write(out, propertyDescriptor);
            }
            out.endArray();
            ImmutableList<AdviceConfig> adviceConfigsElements = instance.adviceConfigs();
            out.name("advice");
            out.beginArray();
            for (AdviceConfig e : adviceConfigsElements) {
                this.adviceConfigsTypeAdapter.write(out, e);
            }
            out.endArray();
            ImmutableList<String> immutableList = instance.classes();
            out.name("classes");
            out.beginArray();
            for (String e : immutableList) {
                out.value(e);
            }
            out.endArray();
            out.name("collocate");
            out.value(instance.collocate());
            out.endObject();
        }

        private InstrumentationDescriptor readInstrumentationDescriptor(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableInstrumentationDescriptor.Builder builder = ImmutableInstrumentationDescriptor.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableInstrumentationDescriptor.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'n': {
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
                case 'p': {
                    if (!"properties".equals(attributeName)) break;
                    this.readInProperties(in, builder);
                    return;
                }
                case 'a': {
                    if (!"advice".equals(attributeName)) break;
                    this.readInAdviceConfigs(in, builder);
                    return;
                }
                case 'c': {
                    if ("classes".equals(attributeName)) {
                        this.readInClasses(in, builder);
                        return;
                    }
                    if (!"collocate".equals(attributeName)) break;
                    this.readInCollocate(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableInstrumentationDescriptor.Builder builder) throws IOException {
            builder.id(in.nextString());
        }

        private void readInName(JsonReader in, ImmutableInstrumentationDescriptor.Builder builder) throws IOException {
            builder.name(in.nextString());
        }

        private void readInProperties(JsonReader in, ImmutableInstrumentationDescriptor.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    PropertyDescriptor value = this.propertiesTypeAdapter.read(in);
                    builder.addProperties(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                PropertyDescriptor value = this.propertiesTypeAdapter.read(in);
                builder.addProperties(value);
            }
        }

        private void readInAdviceConfigs(JsonReader in, ImmutableInstrumentationDescriptor.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    AdviceConfig value = this.adviceConfigsTypeAdapter.read(in);
                    builder.addAdviceConfigs(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                AdviceConfig value = this.adviceConfigsTypeAdapter.read(in);
                builder.addAdviceConfigs(value);
            }
        }

        private void readInClasses(JsonReader in, ImmutableInstrumentationDescriptor.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addClasses(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addClasses(in.nextString());
            }
        }

        private void readInCollocate(JsonReader in, ImmutableInstrumentationDescriptor.Builder builder) throws IOException {
            builder.collocate(in.nextBoolean());
        }
    }
}

