/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.gson.Gson;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapter;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapterFactory;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.reflect.TypeToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.glowroot.instrumentation.engine.config.DefaultValue;
import org.glowroot.instrumentation.engine.config.ImmutablePropertyDescriptor;
import org.glowroot.instrumentation.engine.config.PropertyDescriptor;
import org.immutables.value.Generated;

@Generated(from="org.glowroot.instrumentation.engine.config", generator="Gsons")
public final class GsonAdaptersPropertyDescriptor
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (PropertyDescriptorTypeAdapter.adapts(type)) {
            return new PropertyDescriptorTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersPropertyDescriptor(PropertyDescriptor)";
    }

    @Generated(from="PropertyDescriptor", generator="Gsons")
    private static class PropertyDescriptorTypeAdapter
    extends TypeAdapter<PropertyDescriptor> {
        public final DefaultValue.PropertyType typeTypeSample = null;
        public final DefaultValue defaultValueTypeSample = null;
        private final TypeAdapter<DefaultValue.PropertyType> typeTypeAdapter;
        private final TypeAdapter<DefaultValue> defaultValueTypeAdapter;

        PropertyDescriptorTypeAdapter(Gson gson) {
            this.typeTypeAdapter = gson.getAdapter(DefaultValue.PropertyType.class);
            this.defaultValueTypeAdapter = gson.getAdapter(DefaultValue.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return PropertyDescriptor.class == type.getRawType() || ImmutablePropertyDescriptor.class == type.getRawType();
        }

        @Override
        public void write(JsonWriter out, PropertyDescriptor value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writePropertyDescriptor(out, value);
            }
        }

        @Override
        public PropertyDescriptor read(JsonReader in) throws IOException {
            return this.readPropertyDescriptor(in);
        }

        private void writePropertyDescriptor(JsonWriter out, PropertyDescriptor instance) throws IOException {
            out.beginObject();
            out.name("name");
            out.value(instance.name());
            out.name("type");
            this.typeTypeAdapter.write(out, instance.type());
            DefaultValue defaultValueValue = instance.defaultValue();
            if (defaultValueValue != null) {
                out.name("default");
                this.defaultValueTypeAdapter.write(out, defaultValueValue);
            } else if (out.getSerializeNulls()) {
                out.name("default");
                out.nullValue();
            }
            out.name("label");
            out.value(instance.label());
            out.name("checkboxLabel");
            out.value(instance.checkboxLabel());
            out.name("description");
            out.value(instance.description());
            out.endObject();
        }

        private PropertyDescriptor readPropertyDescriptor(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutablePropertyDescriptor.Builder builder = ImmutablePropertyDescriptor.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutablePropertyDescriptor.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'n': {
                    if (!"name".equals(attributeName)) break;
                    this.readInName(in, builder);
                    return;
                }
                case 't': {
                    if (!"type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 'd': {
                    if ("default".equals(attributeName)) {
                        this.readInDefaultValue(in, builder);
                        return;
                    }
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
                case 'l': {
                    if (!"label".equals(attributeName)) break;
                    this.readInLabel(in, builder);
                    return;
                }
                case 'c': {
                    if (!"checkboxLabel".equals(attributeName)) break;
                    this.readInCheckboxLabel(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInName(JsonReader in, ImmutablePropertyDescriptor.Builder builder) throws IOException {
            builder.name(in.nextString());
        }

        private void readInType(JsonReader in, ImmutablePropertyDescriptor.Builder builder) throws IOException {
            DefaultValue.PropertyType value = this.typeTypeAdapter.read(in);
            builder.type(value);
        }

        private void readInDefaultValue(JsonReader in, ImmutablePropertyDescriptor.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                DefaultValue value = this.defaultValueTypeAdapter.read(in);
                builder.defaultValue(value);
            }
        }

        private void readInLabel(JsonReader in, ImmutablePropertyDescriptor.Builder builder) throws IOException {
            builder.label(in.nextString());
        }

        private void readInCheckboxLabel(JsonReader in, ImmutablePropertyDescriptor.Builder builder) throws IOException {
            builder.checkboxLabel(in.nextString());
        }

        private void readInDescription(JsonReader in, ImmutablePropertyDescriptor.Builder builder) throws IOException {
            builder.description(in.nextString());
        }
    }
}

