/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Charsets;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Resources;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.Gson;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.GsonBuilder;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapter;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.TypeAdapterFactory;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.reflect.TypeToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonReader;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonToken;
import com.microsoft.applicationinsights.agent.shadow.com.google.gson.stream.JsonWriter;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.glowroot.instrumentation.engine.config.DefaultValue;
import org.glowroot.instrumentation.engine.config.GsonAdaptersAdviceConfig;
import org.glowroot.instrumentation.engine.config.GsonAdaptersInstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.GsonAdaptersPropertyDescriptor;
import org.glowroot.instrumentation.engine.config.ImmutableInstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;

public class InstrumentationDescriptors {
    private static final Gson gson;

    private InstrumentationDescriptors() {
    }

    public static List<InstrumentationDescriptor> read() throws IOException {
        List<URL> resources = InstrumentationDescriptors.getResources("META-INF/instrumentation.list");
        ArrayList<InstrumentationDescriptor> descriptors = Lists.newArrayList();
        for (URL resource : resources) {
            List<String> jsonFiles = Resources.readLines(resource, Charsets.ISO_8859_1);
            for (String jsonFile : jsonFiles) {
                if (jsonFile.isEmpty()) continue;
                URL url = InstrumentationDescriptors.class.getResource("/META-INF/" + jsonFile);
                if (url == null) {
                    throw new IllegalStateException("No such resource: /META-INF/" + jsonFile);
                }
                descriptors.add(InstrumentationDescriptors.read(url));
            }
        }
        return Preconditions.checkNotNull(descriptors);
    }

    public static InstrumentationDescriptor read(URL url) throws IOException {
        String json = Resources.toString(url, Charsets.ISO_8859_1);
        return Preconditions.checkNotNull(gson.fromJson(json, ImmutableInstrumentationDescriptor.class));
    }

    private static List<URL> getResources(String resourceName) throws IOException {
        ClassLoader loader = InstrumentationDescriptors.class.getClassLoader();
        if (loader == null) {
            return ImmutableList.copyOf(Iterators.forEnumeration(ClassLoader.getSystemResources(resourceName)));
        }
        return ImmutableList.copyOf(Iterators.forEnumeration(loader.getResources(resourceName)));
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(new GsonAdaptersInstrumentationDescriptor());
        gsonBuilder.registerTypeAdapterFactory(new GsonAdaptersPropertyDescriptor());
        gsonBuilder.registerTypeAdapterFactory(new GsonAdaptersAdviceConfig());
        gsonBuilder.registerTypeAdapter((Type)((Object)DefaultValue.class), new DefaultValue.PropertyValueTypeAdapter());
        gsonBuilder.registerTypeAdapterFactory(new EnumTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    private static class EnumTypeAdapterFactory
    implements TypeAdapterFactory {
        private EnumTypeAdapterFactory() {
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class<T> rawType = type.getRawType();
            if (!rawType.isEnum()) {
                return null;
            }
            final HashMap<String, T> enumConstants = Maps.newHashMap();
            for (T enumConstant : rawType.getEnumConstants()) {
                enumConstants.put(((Enum)enumConstant).name().replace('_', '-').toLowerCase(Locale.ENGLISH), enumConstant);
            }
            return new TypeAdapter<T>(){

                @Override
                @Nullable
                public T read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return null;
                    }
                    return enumConstants.get(in.nextString());
                }

                @Override
                public void write(JsonWriter out, T value) throws IOException {
                    throw new UnsupportedOperationException("This should not be needed");
                }
            };
        }
    }
}

