/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.impl;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Booleans;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import org.glowroot.instrumentation.engine.impl.TimerNameImpl;
import org.immutables.value.Generated;

@Generated(from="TimerNameImpl", generator="Immutables")
public final class ImmutableTimerNameImpl
extends TimerNameImpl {
    private final String name;
    private final boolean extended;
    @Nullable
    private final transient TimerNameImpl extendedTimer;
    private final transient int specialHashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTimerNameImpl(String name, boolean extended) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.extended = extended;
        this.extendedTimer = this.initShim.extendedTimer();
        this.specialHashCode = this.initShim.specialHashCode();
        this.initShim = null;
    }

    private ImmutableTimerNameImpl(ImmutableTimerNameImpl original, String name, boolean extended) {
        this.name = name;
        this.extended = extended;
        this.extendedTimer = this.initShim.extendedTimer();
        this.specialHashCode = this.initShim.specialHashCode();
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean extended() {
        return this.extended;
    }

    @Override
    @Nullable
    public TimerNameImpl extendedTimer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.extendedTimer() : this.extendedTimer;
    }

    @Override
    public int specialHashCode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.specialHashCode() : this.specialHashCode;
    }

    public final ImmutableTimerNameImpl withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTimerNameImpl(this, newValue, this.extended);
    }

    public final ImmutableTimerNameImpl withExtended(boolean value) {
        if (this.extended == value) {
            return this;
        }
        return new ImmutableTimerNameImpl(this, this.name, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTimerNameImpl && this.equalTo((ImmutableTimerNameImpl)another);
    }

    private boolean equalTo(ImmutableTimerNameImpl another) {
        return this.name.equals(another.name) && this.extended == another.extended && Objects.equal(this.extendedTimer, another.extendedTimer) && this.specialHashCode == another.specialHashCode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Booleans.hashCode(this.extended);
        h += (h << 5) + Objects.hashCode(this.extendedTimer);
        h += (h << 5) + this.specialHashCode;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TimerNameImpl").omitNullValues().add("name", this.name).add("extended", this.extended).add("extendedTimer", this.extendedTimer).add("specialHashCode", this.specialHashCode).toString();
    }

    public static ImmutableTimerNameImpl of(String name, boolean extended) {
        return new ImmutableTimerNameImpl(name, extended);
    }

    public static ImmutableTimerNameImpl copyOf(TimerNameImpl instance) {
        if (instance instanceof ImmutableTimerNameImpl) {
            return (ImmutableTimerNameImpl)instance;
        }
        return ImmutableTimerNameImpl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TimerNameImpl", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_EXTENDED = 2L;
        private long initBits = 3L;
        private String name;
        private boolean extended;

        private Builder() {
        }

        public final Builder from(TimerNameImpl instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.name(instance.name());
            this.extended(instance.extended());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder extended(boolean extended) {
            this.extended = extended;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTimerNameImpl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTimerNameImpl(null, this.name, this.extended);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("extended");
            }
            return "Cannot build TimerNameImpl, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="TimerNameImpl", generator="Immutables")
    private final class InitShim {
        private byte extendedTimerBuildStage = 0;
        private TimerNameImpl extendedTimer;
        private byte specialHashCodeBuildStage = 0;
        private int specialHashCode;

        private InitShim() {
        }

        TimerNameImpl extendedTimer() {
            if (this.extendedTimerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extendedTimerBuildStage == 0) {
                this.extendedTimerBuildStage = (byte)-1;
                this.extendedTimer = ImmutableTimerNameImpl.super.extendedTimer();
                this.extendedTimerBuildStage = 1;
            }
            return this.extendedTimer;
        }

        int specialHashCode() {
            if (this.specialHashCodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.specialHashCodeBuildStage == 0) {
                this.specialHashCodeBuildStage = (byte)-1;
                this.specialHashCode = ImmutableTimerNameImpl.super.specialHashCode();
                this.specialHashCodeBuildStage = 1;
            }
            return this.specialHashCode;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.extendedTimerBuildStage == -1) {
                attributes.add("extendedTimer");
            }
            if (this.specialHashCodeBuildStage == -1) {
                attributes.add("specialHashCode");
            }
            return "Cannot build TimerNameImpl, attribute initializers form cycle " + attributes;
        }
    }
}

