/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.impl;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import org.glowroot.instrumentation.api.AsyncQuerySpan;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Getter;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextPlus;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.instrumentation.engine.impl.NopTransactionService;
import org.glowroot.instrumentation.engine.spi.AgentSPI;

public class OptionalThreadContextImpl
implements ThreadContextPlus {
    private static final Logger logger = LoggerFactory.getLogger(OptionalThreadContextImpl.class);
    private int rootNestingGroupId;
    private int rootSuppressionKeyId;
    @MonotonicNonNull
    private ThreadContextPlus threadContext;
    private final AgentSPI agentSPI;
    private final ThreadContextThreadLocal.Holder threadContextHolder;

    public OptionalThreadContextImpl(AgentSPI agentSPI, ThreadContextThreadLocal.Holder threadContextHolder, int rootNestingGroupId, int rootSuppressionKeyId) {
        this.agentSPI = agentSPI;
        this.threadContextHolder = threadContextHolder;
        this.rootNestingGroupId = rootNestingGroupId;
        this.rootSuppressionKeyId = rootSuppressionKeyId;
    }

    @Override
    public boolean isInTransaction() {
        return this.threadContext != null;
    }

    @Override
    public <C> Span startIncomingSpan(String operationType, String transactionName, Getter<C> getter, C carrier, MessageSupplier messageSupplier, TimerName timerName, OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior) {
        if (operationType == null) {
            logger.error("startIncomingSpan(): argument 'transactionType' must be non-null");
            return NopTransactionService.LOCAL_SPAN;
        }
        if (transactionName == null) {
            logger.error("startIncomingSpan(): argument 'transactionName' must be non-null");
            return NopTransactionService.LOCAL_SPAN;
        }
        if (messageSupplier == null) {
            logger.error("startIncomingSpan(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.LOCAL_SPAN;
        }
        if (timerName == null) {
            logger.error("startIncomingSpan(): argument 'timerName' must be non-null");
            return NopTransactionService.LOCAL_SPAN;
        }
        if (this.threadContext == null) {
            Span span = this.agentSPI.startIncomingSpan(operationType, transactionName, getter, carrier, messageSupplier, timerName, this.threadContextHolder, this.rootNestingGroupId, this.rootSuppressionKeyId);
            this.threadContext = Preconditions.checkNotNull(this.threadContextHolder.get());
            return span;
        }
        return this.threadContext.startIncomingSpan(operationType, transactionName, getter, carrier, messageSupplier, timerName, alreadyInTransactionBehavior);
    }

    @Override
    public Span startLocalSpan(MessageSupplier messageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.LOCAL_SPAN;
        }
        return this.threadContext.startLocalSpan(messageSupplier, timerName);
    }

    @Override
    public QuerySpan startQuerySpan(String type, String dest, String text, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.QUERY_SPAN;
        }
        return this.threadContext.startQuerySpan(type, dest, text, queryMessageSupplier, timerName);
    }

    @Override
    public QuerySpan startQuerySpan(String type, String dest, String text, long queryExecutionCount, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.QUERY_SPAN;
        }
        return this.threadContext.startQuerySpan(type, dest, text, queryExecutionCount, queryMessageSupplier, timerName);
    }

    @Override
    public AsyncQuerySpan startAsyncQuerySpan(String type, String dest, String text, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.ASYNC_QUERY_SPAN;
        }
        return this.threadContext.startAsyncQuerySpan(type, dest, text, queryMessageSupplier, timerName);
    }

    @Override
    public <C> Span startOutgoingSpan(String serviceCallType, String serviceCallText, Setter<C> setter, C carrier, MessageSupplier messageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.LOCAL_SPAN;
        }
        return this.threadContext.startOutgoingSpan(serviceCallType, serviceCallText, setter, carrier, messageSupplier, timerName);
    }

    @Override
    public <C> AsyncSpan startAsyncOutgoingSpan(String serviceCallType, String serviceCallText, Setter<C> setter, C carrier, MessageSupplier messageSupplier, TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.ASYNC_SPAN;
        }
        return this.threadContext.startAsyncOutgoingSpan(serviceCallType, serviceCallText, setter, carrier, messageSupplier, timerName);
    }

    @Override
    public void captureLoggerSpan(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        if (this.threadContext != null) {
            this.threadContext.captureLoggerSpan(messageSupplier, throwable);
        }
    }

    @Override
    public Timer startTimer(TimerName timerName) {
        if (this.threadContext == null) {
            return NopTransactionService.TIMER;
        }
        return this.threadContext.startTimer(timerName);
    }

    @Override
    public AuxThreadContext createAuxThreadContext() {
        if (this.threadContext == null) {
            return NopTransactionService.AUX_THREAD_CONTEXT;
        }
        return this.threadContext.createAuxThreadContext();
    }

    @Override
    public void setTransactionAsync() {
        if (this.threadContext != null) {
            this.threadContext.setTransactionAsync();
        }
    }

    @Override
    public void setTransactionAsyncComplete() {
        if (this.threadContext != null) {
            this.threadContext.setTransactionAsyncComplete();
        }
    }

    @Override
    public void setTransactionType(@Nullable String transactionType, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionType(transactionType, priority);
        }
    }

    @Override
    public void setTransactionName(@Nullable String transactionName, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionName(transactionName, priority);
        }
    }

    @Override
    public void setTransactionUser(@Nullable String user, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionUser(user, priority);
        }
    }

    @Override
    public void addTransactionAttribute(String name, @Nullable String value) {
        if (this.threadContext != null) {
            this.threadContext.addTransactionAttribute(name, value);
        }
    }

    @Override
    public void setTransactionSlowThreshold(long threshold, TimeUnit unit, int priority) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionSlowThreshold(threshold, unit, priority);
        }
    }

    @Override
    public void setTransactionError(Throwable t) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionError(t);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionError(message);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message, @Nullable Throwable t) {
        if (this.threadContext != null) {
            this.threadContext.setTransactionError(message, t);
        }
    }

    @Override
    public void trackResourceAcquired(Object resource, boolean withLocationStackTrace) {
        if (this.threadContext != null) {
            this.threadContext.trackResourceAcquired(resource, withLocationStackTrace);
        }
    }

    @Override
    public void trackResourceReleased(Object resource) {
        if (this.threadContext != null) {
            this.threadContext.trackResourceReleased(resource);
        }
    }

    @Override
    @Nullable
    public ThreadContext.ServletRequestInfo getServletRequestInfo() {
        if (this.threadContext != null) {
            return this.threadContext.getServletRequestInfo();
        }
        return null;
    }

    @Override
    public void setServletRequestInfo(ThreadContext.ServletRequestInfo servletRequestInfo) {
        if (this.threadContext != null) {
            this.threadContext.setServletRequestInfo(servletRequestInfo);
        }
    }

    @Override
    public int getCurrentNestingGroupId() {
        if (this.threadContext == null) {
            return 0;
        }
        return this.threadContext.getCurrentNestingGroupId();
    }

    @Override
    public void setCurrentNestingGroupId(int nestingGroupId) {
        if (this.threadContext == null) {
            this.rootNestingGroupId = nestingGroupId;
        } else {
            this.threadContext.setCurrentNestingGroupId(nestingGroupId);
        }
    }

    @Override
    public int getCurrentSuppressionKeyId() {
        if (this.threadContext == null) {
            return 0;
        }
        return this.threadContext.getCurrentSuppressionKeyId();
    }

    @Override
    public void setCurrentSuppressionKeyId(int suppressionKeyId) {
        if (this.threadContext == null) {
            this.rootSuppressionKeyId = suppressionKeyId;
        } else {
            this.threadContext.setCurrentSuppressionKeyId(suppressionKeyId);
        }
    }
}

