/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.impl;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.CacheBuilder;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.CacheLoader;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.LoadingCache;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.engine.impl.ImmutableTimerNameImpl;
import org.glowroot.instrumentation.engine.impl.TimerNameImpl;

public class TimerNameCache {
    private static final Logger logger = LoggerFactory.getLogger(TimerNameCache.class);
    private final LoadingCache<String, TimerNameImpl> names = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<String, TimerNameImpl>(){

        @Override
        public TimerNameImpl load(String name) {
            return ImmutableTimerNameImpl.of(name, false);
        }
    });
    private final TimerName unknownTimerName = this.names.getUnchecked("unknown");

    public TimerName getTimerName(String name) {
        if (name == null) {
            logger.error("getTimerName(): argument 'name' must be non-null");
            return this.unknownTimerName;
        }
        return this.names.getUnchecked(name);
    }
}

