/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.init;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Throwables;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Ticker;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.glowroot.instrumentation.api.internal.InstrumentationServiceHolder;
import org.glowroot.instrumentation.engine.bytecode.api.BytecodeServiceHolder;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptors;
import org.glowroot.instrumentation.engine.impl.InstrumentationServiceImpl;
import org.glowroot.instrumentation.engine.impl.SimpleConfigServiceFactory;
import org.glowroot.instrumentation.engine.impl.TimerNameCache;
import org.glowroot.instrumentation.engine.init.IbmJ9Java6HackClassFileTransformer;
import org.glowroot.instrumentation.engine.init.Java9HackClassFileTransformer;
import org.glowroot.instrumentation.engine.init.ManagementFactoryHackClassFileTransformer;
import org.glowroot.instrumentation.engine.init.PreCheckLoadedClasses;
import org.glowroot.instrumentation.engine.init.PreInitializeWeavingClasses;
import org.glowroot.instrumentation.engine.spi.AgentSPI;
import org.glowroot.instrumentation.engine.util.JavaVersion;
import org.glowroot.instrumentation.engine.util.LazyPlatformMBeanServer;
import org.glowroot.instrumentation.engine.weaving.AdviceCache;
import org.glowroot.instrumentation.engine.weaving.AnalyzedWorld;
import org.glowroot.instrumentation.engine.weaving.BytecodeServiceImpl;
import org.glowroot.instrumentation.engine.weaving.Java9;
import org.glowroot.instrumentation.engine.weaving.PointcutClassFileTransformer;
import org.glowroot.instrumentation.engine.weaving.PreloadSomeSuperTypesCache;
import org.glowroot.instrumentation.engine.weaving.Weaver;
import org.glowroot.instrumentation.engine.weaving.WeavingClassFileTransformer;

public class EngineModule {
    private static final Logger logger = LoggerFactory.getLogger(EngineModule.class);
    private static final Logger startupLogger = LoggerFactory.getLogger("org.glowroot.instrumentation");
    private final AdviceCache adviceCache;
    private final PreloadSomeSuperTypesCache preloadSomeSuperTypesCache;
    private final AnalyzedWorld analyzedWorld;
    private final Weaver weaver;
    private final BytecodeServiceImpl bytecodeService;
    @MonotonicNonNull
    private volatile LazyPlatformMBeanServer lazyPlatformMBeanServer;

    public static EngineModule createWithSomeDefaults(@Nullable Instrumentation instrumentation, File tmpDir, ThreadContextThreadLocal threadContextThreadLocal, AgentSPI agentSPI, @Nullable File agentJarFile) throws Exception {
        List<InstrumentationDescriptor> instrumentationDescriptors = InstrumentationDescriptors.read();
        return EngineModule.createWithSomeDefaults(instrumentation, tmpDir, threadContextThreadLocal, instrumentationDescriptors, new SimpleConfigServiceFactory(instrumentationDescriptors), agentSPI, true, ImmutableList.<String>of(), ImmutableList.<String>of(), agentJarFile);
    }

    public static EngineModule createWithSomeDefaults(@Nullable Instrumentation instrumentation, File tmpDir, ThreadContextThreadLocal threadContextThreadLocal, List<InstrumentationDescriptor> instrumentationDescriptors, InstrumentationServiceImpl.ConfigServiceFactory configServiceFactory, AgentSPI agentSPI, boolean useInstrumentationAnnotations, List<String> doNotWeavePrefixes, List<String> tryToLoadInBootstrapClassLoader, @Nullable File agentJarFile) throws Exception {
        return new EngineModule(instrumentation, tmpDir, Ticker.systemTicker(), instrumentationDescriptors, Collections.<AdviceConfig>emptyList(), threadContextThreadLocal, new TimerNameCache(), configServiceFactory, agentSPI, useInstrumentationAnnotations, doNotWeavePrefixes, tryToLoadInBootstrapClassLoader, null, new Class[0], agentJarFile);
    }

    public EngineModule(@Nullable Instrumentation instrumentation, File tmpDir, Ticker ticker, List<InstrumentationDescriptor> instrumentationDescriptors, List<AdviceConfig> reweavableAdviceConfigs, ThreadContextThreadLocal threadContextThreadLocal, TimerNameCache timerNameCache, InstrumentationServiceImpl.ConfigServiceFactory configServiceFactory, AgentSPI agentSPI, boolean useInstrumentationAnnotations, List<String> doNotWeavePrefixes, List<String> tryToLoadInBootstrapClassLoader, @Nullable PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer, Class<?>[] allPreCheckLoadedClasses, @Nullable File agentJarFile) throws Exception {
        try {
            if (instrumentation != null) {
                instrumentation.addTransformer(new ManagementFactoryHackClassFileTransformer());
                ManagementFactory.getThreadMXBean();
                if (JavaVersion.isGreaterThanOrEqualToJava9()) {
                    Object baseModule = Java9.getModule(ClassLoader.class);
                    Java9.grantAccessToEngine(instrumentation, baseModule);
                    Java9.grantAccess(instrumentation, "org.glowroot.instrumentation.engine.weaving.ClassLoaders", "java.lang.ClassLoader", false);
                    instrumentation.addTransformer(new Java9HackClassFileTransformer());
                    Class.forName("org.glowroot.instrumentation.engine.weaving.WeavingClassFileTransformer");
                }
                if (JavaVersion.isJ9Jvm() && JavaVersion.isJava6()) {
                    instrumentation.addTransformer(new IbmJ9Java6HackClassFileTransformer());
                    Class.forName("com.microsoft.applicationinsights.agent.shadow.com.google.protobuf.UnsafeUtil");
                }
            }
            PointcutClassFileTransformer pointcutClassFileTransformer = null;
            if (instrumentation != null) {
                for (InstrumentationDescriptor descriptor : instrumentationDescriptors) {
                    File jarFile = descriptor.jarFile();
                    if (jarFile == null) continue;
                    instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(jarFile));
                }
                pointcutClassFileTransformer = new PointcutClassFileTransformer();
                instrumentation.addTransformer(pointcutClassFileTransformer);
            }
            this.adviceCache = new AdviceCache(instrumentationDescriptors, reweavableAdviceConfigs, instrumentation, doNotWeavePrefixes, tmpDir);
            if (pointcutClassFileTransformer != null) {
                Preconditions.checkNotNull(instrumentation).removeTransformer(pointcutClassFileTransformer);
            }
            this.preloadSomeSuperTypesCache = new PreloadSomeSuperTypesCache(new File(tmpDir, "preload-some-super-types-cache"), 50000);
            this.analyzedWorld = new AnalyzedWorld(this.adviceCache.getAdvisorsSupplier(), this.adviceCache.getShimTypes(), this.adviceCache.getMixinTypes(), useInstrumentationAnnotations, instrumentation, this.preloadSomeSuperTypesCache);
            this.weaver = new Weaver(this.adviceCache.getAdvisorsSupplier(), this.adviceCache.getShimTypes(), this.adviceCache.getMixinTypes(), this.analyzedWorld, ticker);
            InstrumentationServiceHolder.set(new InstrumentationServiceImpl(timerNameCache, configServiceFactory));
            this.bytecodeService = new BytecodeServiceImpl(threadContextThreadLocal, agentSPI, tryToLoadInBootstrapClassLoader, this.preloadSomeSuperTypesCache);
            BytecodeServiceHolder.set(this.bytecodeService);
            this.bytecodeService.addOnEnteringMain(new BytecodeServiceImpl.OnEnteringMain(){

                @Override
                public void run(@Nullable String mainClass) throws Exception {
                    EngineModule.this.weaver.setNoLongerNeedToWeaveMainMethods();
                    EngineModule.this.lazyPlatformMBeanServer = LazyPlatformMBeanServer.create(mainClass);
                    EngineModule.this.bytecodeService.setOnExitingGetPlatformMBeanServer(new Runnable(){

                        @Override
                        public void run() {
                            Preconditions.checkNotNull(EngineModule.this.lazyPlatformMBeanServer);
                            EngineModule.this.lazyPlatformMBeanServer.setPlatformMBeanServerAvailable();
                        }
                    });
                }
            });
        }
        catch (Throwable t) {
            BytecodeServiceHolder.setEngineFailedToStart();
            Throwables.propagateIfPossible(t, Exception.class);
            throw new Exception(t);
        }
        if (instrumentation != null) {
            PreInitializeWeavingClasses.preInitializeClasses();
            ArrayList<String> internalNames = Lists.newArrayList();
            for (String doNotWeavePrefix : doNotWeavePrefixes) {
                internalNames.add(doNotWeavePrefix.replace('.', '/'));
            }
            WeavingClassFileTransformer transformer = new WeavingClassFileTransformer(this.weaver, instrumentation, internalNames);
            boolean retransformClassesSupported = instrumentation.isRetransformClassesSupported();
            if (retransformClassesSupported) {
                instrumentation.addTransformer(transformer, true);
            } else {
                instrumentation.addTransformer(transformer);
            }
            Class[] allLoadedClasses = instrumentation.getAllLoadedClasses();
            this.adviceCache.initialReweave(allLoadedClasses);
            if (preCheckClassFileTransformer == null) {
                EngineModule.logAnyImportantClassLoadedPriorToWeavingInit(allLoadedClasses, agentJarFile, false);
            } else {
                EngineModule.logPreCheckInfo(allPreCheckLoadedClasses, agentJarFile, preCheckClassFileTransformer);
                instrumentation.removeTransformer(preCheckClassFileTransformer);
            }
            if (retransformClassesSupported) {
                instrumentation.retransformClasses(ClassLoader.class);
            }
            try {
                Class.forName("sun.net.www.protocol.ftp.Handler");
                Class.forName("sun.net.www.protocol.ftp.FtpURLConnection");
            }
            catch (ClassNotFoundException e) {
                logger.debug(e.getMessage(), e);
            }
            try {
                Class.forName("java.net.HttpURLConnection");
            }
            catch (ClassNotFoundException e) {
                logger.warn(e.getMessage(), e);
            }
        }
        EngineModule.initInstrumentation(instrumentationDescriptors);
    }

    public void addOnEnteringMain(BytecodeServiceImpl.OnEnteringMain onEnteringMain) {
        this.bytecodeService.addOnEnteringMain(onEnteringMain);
    }

    public AdviceCache getAdviceCache() {
        return this.adviceCache;
    }

    public PreloadSomeSuperTypesCache getPreloadSomeSuperTypesCache() {
        return this.preloadSomeSuperTypesCache;
    }

    public AnalyzedWorld getAnalyzedWorld() {
        return this.analyzedWorld;
    }

    public Weaver getWeaver() {
        return this.weaver;
    }

    public LazyPlatformMBeanServer getLazyPlatformMBeanServer() {
        if (this.lazyPlatformMBeanServer == null) {
            throw new IllegalStateException("onEnteringMain() was never called");
        }
        return this.lazyPlatformMBeanServer;
    }

    private static void logPreCheckInfo(Class<?>[] allPreCheckLoadedClasses, @Nullable File agentJarFile, PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer) {
        if (EngineModule.logAnyImportantClassLoadedPriorToWeavingInit(allPreCheckLoadedClasses, agentJarFile, true)) {
            ArrayList<String> classNames = Lists.newArrayList();
            for (Class<?> clazz : allPreCheckLoadedClasses) {
                String className = clazz.getName();
                if (className.startsWith("[")) continue;
                classNames.add(className);
            }
            Collections.sort(classNames);
            startupLogger.warn("PRE-CHECK: full list of classes already loaded: {}", (Object)Joiner.on(", ").join(classNames));
            for (Map.Entry entry : preCheckClassFileTransformer.getImportantClassLoadingPoints().entrySet()) {
                startupLogger.warn("PRE-CHECK: loading location of important class: {}", entry.getKey(), entry.getValue());
            }
        } else {
            startupLogger.info("PRE-CHECK: successful");
        }
    }

    private static boolean logAnyImportantClassLoadedPriorToWeavingInit(Class<?>[] allLoadedClasses, @Nullable File agentJarFile, boolean preCheck) {
        ArrayList<String> loadedImportantClassNames = Lists.newArrayList();
        for (Class<?> loadedClass : allLoadedClasses) {
            String className = loadedClass.getName();
            if (!PreCheckLoadedClasses.isImportantClass(className, loadedClass)) continue;
            loadedImportantClassNames.add(className);
        }
        if (loadedImportantClassNames.isEmpty()) {
            return false;
        }
        EngineModule.logLoadedImportantClassWarning(loadedImportantClassNames, agentJarFile, preCheck);
        return true;
    }

    private static void initInstrumentation(List<InstrumentationDescriptor> instrumentationDescriptors) {
        for (InstrumentationDescriptor descriptor : instrumentationDescriptors) {
            for (String clazz : descriptor.classes()) {
                try {
                    Class.forName(clazz, true, EngineModule.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
        }
    }

    private static void logLoadedImportantClassWarning(List<String> loadedImportantClassNames, @Nullable File agentJarFile, boolean preCheck) {
        if (preCheck) {
            startupLogger.warn("PRE-CHECK: one or more important classes were loaded before agent initialization: {}", (Object)Joiner.on(", ").join(loadedImportantClassNames));
            return;
        }
        List<String> javaAgentArgsBeforeThisAgent = EngineModule.getJavaAgentArgsBeforeThisAgent(agentJarFile);
        if (!javaAgentArgsBeforeThisAgent.isEmpty()) {
            startupLogger.warn("one or more important classes were loaded before  instrumentation could be applied to them: {}. This likely occurred because one or more other javaagents ({}) are listed in the JVM args prior to this agent which which gives them a higher loading precedence.", (Object)Joiner.on(", ").join(loadedImportantClassNames), (Object)Joiner.on(" ").join(javaAgentArgsBeforeThisAgent));
            return;
        }
        List<String> nativeAgentArgs = EngineModule.getNativeAgentArgs();
        if (!nativeAgentArgs.isEmpty()) {
            startupLogger.warn("one or more important classes were loaded before instrumentation could be applied to them: {}. This likely occurred because one or more native agents ({}) are listed in the JVM args, and native agents have higher loading precedence than java agents.", (Object)Joiner.on(", ").join(loadedImportantClassNames), (Object)Joiner.on(" ").join(nativeAgentArgs));
            return;
        }
        startupLogger.warn("one or more important classes were loaded before instrumentation could be applied to them: {}", (Object)Joiner.on(", ").join(loadedImportantClassNames));
    }

    private static List<String> getNativeAgentArgs() {
        ArrayList<String> nativeAgentArgs = Lists.newArrayList();
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!jvmArg.startsWith("-agentpath:") && !jvmArg.startsWith("-agentlib:")) continue;
            nativeAgentArgs.add(jvmArg);
        }
        return nativeAgentArgs;
    }

    private static List<String> getJavaAgentArgsBeforeThisAgent(@Nullable File agentJarFile) {
        String jvmArg;
        if (agentJarFile == null) {
            return ImmutableList.of();
        }
        ArrayList<String> javaAgentArgsBeforeThisAgent = Lists.newArrayList();
        Iterator<String> iterator = ManagementFactory.getRuntimeMXBean().getInputArguments().iterator();
        while (!(!iterator.hasNext() || (jvmArg = iterator.next()).startsWith("-javaagent:") && jvmArg.endsWith(agentJarFile.getName()))) {
            if (!jvmArg.startsWith("-javaagent:") && !EngineModule.isIbmJ9HealthcenterArg(jvmArg)) continue;
            javaAgentArgsBeforeThisAgent.add(jvmArg);
        }
        return javaAgentArgsBeforeThisAgent;
    }

    private static boolean isIbmJ9HealthcenterArg(String jvmArg) {
        return JavaVersion.isJ9Jvm() && (jvmArg.equals("-Xhealthcenter") || jvmArg.startsWith("-Xhealthcenter:"));
    }
}

