/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.init;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import org.glowroot.instrumentation.engine.init.IbmJ9Java6HackClassFileTransformer2;
import org.glowroot.instrumentation.engine.init.PreCheckLoadedClasses;
import org.glowroot.instrumentation.engine.util.JavaVersion;

public class MainEntryPointUtil {
    private MainEntryPointUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger initLogging(String name, @Nullable Instrumentation instrumentation) {
        if (JavaVersion.isJava6() && "IBM J9 VM".equals(System.getProperty("java.vm.name")) && instrumentation != null) {
            instrumentation.addTransformer(new IbmJ9Java6HackClassFileTransformer2());
        }
        ClassLoader priorLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new ClassLoader(null){

            @Override
            @Nullable
            public InputStream getResourceAsStream(String name) {
                if (name.equals("META-INF/services/javax.xml.parsers.SAXParserFactory")) {
                    return new ByteArrayInputStream(new byte[0]);
                }
                return null;
            }
        });
        try {
            Logger logger = LoggerFactory.getLogger(name);
            PreCheckLoadedClasses.PreCheckClassFileTransformer.initLogger();
            Logger logger2 = logger;
            return logger2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(priorLoader);
        }
    }
}

