/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Supplier;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSet;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterables;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.glowroot.instrumentation.api.weaving.Shim;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.AdviceBuilder;
import org.glowroot.instrumentation.engine.weaving.AdviceGenerator;
import org.glowroot.instrumentation.engine.weaving.ClassLoaders;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetail;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder;
import org.glowroot.instrumentation.engine.weaving.MixinType;
import org.glowroot.instrumentation.engine.weaving.Reweaving;
import org.glowroot.instrumentation.engine.weaving.ShimType;

public class AdviceCache {
    private static final Logger logger = LoggerFactory.getLogger(AdviceCache.class);
    private final ImmutableList<Advice> nonReweavableAdvisors;
    private final ImmutableList<ShimType> shimTypes;
    private final ImmutableList<MixinType> mixinTypes;
    @Nullable
    private final Instrumentation instrumentation;
    private final List<String> doNotWeavePrefixes;
    private final File tmpDir;
    private volatile ImmutableSet<AdviceConfig> reweavableAdviceConfigs;
    private volatile ImmutableList<Advice> reweavableAdvisors;
    private volatile ImmutableList<Advice> allAdvisors;

    public AdviceCache(List<InstrumentationDescriptor> instrumentationDescriptors, List<AdviceConfig> reweavableAdviceConfigs, @Nullable Instrumentation instrumentation, List<String> doNotWeavePrefixes, File tmpDir) throws Exception {
        ArrayList<Advice> nonReweavableAdvisors = Lists.newArrayList();
        ArrayList<ShimType> shimTypes = Lists.newArrayList();
        ArrayList<MixinType> mixinTypes = Lists.newArrayList();
        HashMap<Advice, ClassLoaders.LazyDefinedClass> lazyAdvisors = Maps.newHashMap();
        for (InstrumentationDescriptor instrumentationDescriptor : instrumentationDescriptors) {
            InstrumentationDetailBuilder builder = new InstrumentationDetailBuilder(instrumentationDescriptor);
            InstrumentationDetail detail = builder.build();
            nonReweavableAdvisors.addAll(AdviceCache.getAdvisors(detail.pointcutClasses()));
            mixinTypes.addAll(AdviceCache.getMixinTypes(detail.mixinClasses()));
            shimTypes.addAll(AdviceCache.getShimTypes(detail.shimClasses()));
            ImmutableList<AdviceConfig> configs = instrumentationDescriptor.adviceConfigs();
            for (AdviceConfig config : configs) {
                config.logValidationErrorsIfAny();
            }
            lazyAdvisors.putAll(AdviceGenerator.createAdvisors(configs, instrumentationDescriptor.id(), instrumentationDescriptor.jarFile() != null, false));
        }
        for (Map.Entry entry : lazyAdvisors.entrySet()) {
            nonReweavableAdvisors.add((Advice)entry.getKey());
        }
        if (instrumentation == null) {
            ClassLoader isolatedWeavingClassLoader = Thread.currentThread().getContextClassLoader();
            Preconditions.checkNotNull(isolatedWeavingClassLoader);
            ClassLoaders.defineClasses(lazyAdvisors.values(), isolatedWeavingClassLoader);
        } else {
            ClassLoaders.createDirectoryOrCleanPreviousContentsWithPrefix(tmpDir, "instrumentation-advice-");
            ClassLoaders.defineClassesInBootstrapClassLoader(lazyAdvisors.values(), instrumentation, tmpDir, "instrumentation-advice-");
        }
        this.nonReweavableAdvisors = ImmutableList.copyOf(nonReweavableAdvisors);
        this.shimTypes = ImmutableList.copyOf(shimTypes);
        this.mixinTypes = ImmutableList.copyOf(mixinTypes);
        this.instrumentation = instrumentation;
        this.doNotWeavePrefixes = doNotWeavePrefixes;
        this.tmpDir = tmpDir;
        this.reweavableAdviceConfigs = ImmutableSet.copyOf(reweavableAdviceConfigs);
        this.reweavableAdvisors = AdviceCache.createReweavableAdvisors(reweavableAdviceConfigs, instrumentation, tmpDir, true);
        this.allAdvisors = ImmutableList.copyOf(Iterables.concat(nonReweavableAdvisors, this.reweavableAdvisors));
    }

    public Supplier<List<Advice>> getAdvisorsSupplier() {
        return new Supplier<List<Advice>>(){

            @Override
            public List<Advice> get() {
                return AdviceCache.this.allAdvisors;
            }
        };
    }

    @VisibleForTesting
    public List<ShimType> getShimTypes() {
        return this.shimTypes;
    }

    @VisibleForTesting
    public List<MixinType> getMixinTypes() {
        return this.mixinTypes;
    }

    public void initialReweave(Class<?>[] initialLoadedClasses) {
        HashSet<Reweaving.PointcutClassName> pointcutClassNames = Sets.newHashSet();
        for (Advice advice : this.allAdvisors) {
            Reweaving.PointcutClassName pointcutClassName = AdviceCache.getPointcutClassName(advice);
            if (pointcutClassName == null || advice.adviceType().getInternalName().startsWith("org/glowroot/instrumentation/executor/ExecutorInstrumentation$RunnableAdvice") || advice.adviceType().getInternalName().startsWith("org/glowroot/instrumentation/executor/ExecutorInstrumentation$CallableAdvice")) continue;
            pointcutClassNames.add(pointcutClassName);
        }
        Reweaving.initialReweave(pointcutClassNames, initialLoadedClasses, Preconditions.checkNotNull(this.instrumentation), this.doNotWeavePrefixes);
    }

    public void updateAdvisors(List<AdviceConfig> reweavableConfigs) throws Exception {
        this.reweavableAdvisors = AdviceCache.createReweavableAdvisors(reweavableConfigs, this.instrumentation, this.tmpDir, false);
        this.reweavableAdviceConfigs = ImmutableSet.copyOf(reweavableConfigs);
        this.allAdvisors = ImmutableList.copyOf(Iterables.concat(this.nonReweavableAdvisors, this.reweavableAdvisors));
    }

    public boolean isOutOfSync(List<AdviceConfig> reweavableAdviceConfigs) {
        return !this.reweavableAdviceConfigs.equals(ImmutableSet.copyOf(reweavableAdviceConfigs));
    }

    private static List<Advice> getAdvisors(List<InstrumentationDetail.PointcutClass> adviceClasses) {
        ArrayList<Advice> advisors = Lists.newArrayList();
        HashMap<String, ClassLoaders.LazyDefinedClass> collocatedClassCache = Maps.newHashMap();
        for (InstrumentationDetail.PointcutClass adviceClass : adviceClasses) {
            try {
                advisors.add(new AdviceBuilder(adviceClass).build(collocatedClassCache));
            }
            catch (Throwable t) {
                logger.error("error creating advice: {}", (Object)adviceClass.type().getClassName(), (Object)t);
            }
        }
        return advisors;
    }

    private static List<MixinType> getMixinTypes(List<InstrumentationDetail.MixinClass> mixinClasses) {
        ArrayList<MixinType> mixinTypes = Lists.newArrayList();
        for (InstrumentationDetail.MixinClass mixinClass : mixinClasses) {
            mixinTypes.add(MixinType.create(mixinClass));
        }
        return mixinTypes;
    }

    private static List<ShimType> getShimTypes(List<InstrumentationDetail.ShimClass> shimClasses) throws ClassNotFoundException {
        ArrayList<ShimType> shimTypes = Lists.newArrayList();
        for (InstrumentationDetail.ShimClass shimClass : shimClasses) {
            Class<?> clazz = Class.forName(shimClass.type().getClassName(), false, AdviceCache.class.getClassLoader());
            Shim shim = clazz.getAnnotation(Shim.class);
            if (shim == null) continue;
            shimTypes.add(ShimType.create(shim, clazz));
        }
        return shimTypes;
    }

    private static ImmutableList<Advice> createReweavableAdvisors(List<AdviceConfig> reweavableAdviceConfigs, @Nullable Instrumentation instrumentation, File tmpDir, boolean cleanTmpDir) throws Exception {
        ImmutableMap<Advice, ClassLoaders.LazyDefinedClass> advisors = AdviceGenerator.createAdvisors(reweavableAdviceConfigs, null, false, true);
        if (instrumentation == null) {
            ClassLoader isolatedWeavingClassLoader = Thread.currentThread().getContextClassLoader();
            Preconditions.checkNotNull(isolatedWeavingClassLoader);
            ClassLoaders.defineClasses(advisors.values(), isolatedWeavingClassLoader);
        } else {
            if (cleanTmpDir) {
                ClassLoaders.createDirectoryOrCleanPreviousContentsWithPrefix(tmpDir, "custom-advice-");
            }
            ClassLoaders.defineClassesInBootstrapClassLoader(advisors.values(), instrumentation, tmpDir, "custom-advice-");
        }
        return ((ImmutableSet)advisors.keySet()).asList();
    }

    @Nullable
    private static Reweaving.PointcutClassName getPointcutClassName(Advice advice) {
        Reweaving.PointcutClassName subTypeRestrictionPointcutClassName = null;
        Pattern subTypeRestrictionPattern = advice.pointcutSubTypeRestrictionPattern();
        if (subTypeRestrictionPattern != null) {
            subTypeRestrictionPointcutClassName = Reweaving.PointcutClassName.fromPattern(subTypeRestrictionPattern, null, false);
        } else {
            String subTypeRestriction = advice.pointcut().subTypeRestriction();
            if (!subTypeRestriction.isEmpty()) {
                subTypeRestrictionPointcutClassName = Reweaving.PointcutClassName.fromNonPattern(subTypeRestriction, null, false);
            }
        }
        Pattern classNamePattern = advice.pointcutClassNamePattern();
        if (classNamePattern != null) {
            return Reweaving.PointcutClassName.fromPattern(classNamePattern, subTypeRestrictionPointcutClassName, advice.pointcut().methodName().equals("<init>"));
        }
        String className = advice.pointcut().className();
        if (!className.isEmpty()) {
            return Reweaving.PointcutClassName.fromNonPattern(className, subTypeRestrictionPointcutClassName, advice.pointcut().methodName().equals("<init>"));
        }
        return null;
    }
}

