/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.CacheBuilder;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.CacheLoader;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.LoadingCache;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.MapMaker;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.glowroot.instrumentation.engine.weaving.Accessor;

public class Beans {
    private static final Logger logger = LoggerFactory.getLogger(Beans.class);
    private static final Accessor SENTINEL_ACCESSOR;
    private static final LoadingCache<Class<?>, ConcurrentMap<String, Accessor>> getters;

    private Beans() {
    }

    @Nullable
    public static Object value(@Nullable Object obj, List<String> path) throws Exception {
        return Beans.value(obj, path, 0);
    }

    @Nullable
    private static Object value(@Nullable Object obj, List<String> path, int currIndex) throws Exception {
        if (obj == null) {
            return null;
        }
        if (currIndex == path.size()) {
            return obj;
        }
        String curr = path.get(currIndex);
        if (obj instanceof Map) {
            if (curr.equals("size")) {
                return ((Map)obj).size();
            }
            return Beans.value(((Map)obj).get(curr), path, currIndex + 1);
        }
        if (obj instanceof List) {
            if (curr.equals("size")) {
                return ((List)obj).size();
            }
            ArrayList<Object> values = Lists.newArrayList();
            for (Object val : (List)obj) {
                values.add(Beans.value(val, path, currIndex));
            }
            return values;
        }
        Accessor accessor = Beans.getAccessor(obj.getClass(), curr);
        if (accessor.equals(SENTINEL_ACCESSOR)) {
            return null;
        }
        Object currItem = accessor.evaluate(obj);
        return Beans.value(currItem, path, currIndex + 1);
    }

    private static Accessor getAccessor(Class<?> clazz, String name) {
        ConcurrentMap<String, Accessor> accessorsForType = getters.getUnchecked(clazz);
        Accessor accessor = (Accessor)accessorsForType.get(name);
        if (accessor == null) {
            accessor = Beans.loadPossiblyArrayBasedAccessor(clazz, name);
            if (accessor == null) {
                accessor = SENTINEL_ACCESSOR;
            }
            accessorsForType.put(name, accessor);
        }
        return accessor;
    }

    @Nullable
    static Accessor loadPossiblyArrayBasedAccessor(Class<?> clazz, String name) {
        if (clazz.getComponentType() != null && name.equals("length")) {
            return Accessor.arrayLength();
        }
        Class<?> componentType = clazz;
        while (componentType.getComponentType() != null) {
            componentType = componentType.getComponentType();
        }
        return Beans.loadAccessor(componentType, name);
    }

    @Nullable
    private static Accessor loadAccessor(Class<?> clazz, String name) {
        String capitalizedName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method method = Beans.getAnyMethod(clazz, "get" + capitalizedName, new Class[0]);
            return Accessor.fromMethod(method);
        }
        catch (Exception e) {
            logger.trace(e.getMessage(), e);
            try {
                Method method = Beans.getAnyMethod(clazz, "is" + capitalizedName, new Class[0]);
                return Accessor.fromMethod(method);
            }
            catch (Exception f) {
                logger.trace(f.getMessage(), f);
                try {
                    Method method = Beans.getAnyMethod(clazz, name, new Class[0]);
                    return Accessor.fromMethod(method);
                }
                catch (Exception g) {
                    logger.trace(g.getMessage(), g);
                    try {
                        Field field = Beans.getAnyField(clazz, name);
                        return Accessor.fromField(field);
                    }
                    catch (Exception h) {
                        logger.trace(h.getMessage(), h);
                        logger.debug("no accessor found for {} in class {}", (Object)name, (Object)clazz.getName());
                        return null;
                    }
                }
            }
        }
    }

    private static Method getAnyMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            logger.trace(e.getMessage(), e);
            return Beans.getAnyDeclaredMethod(clazz, name, parameterTypes);
        }
        catch (NoClassDefFoundError e) {
            logger.trace(e.getMessage(), e);
            return Beans.getAnyDeclaredMethod(clazz, name, parameterTypes);
        }
    }

    private static Field getAnyField(Class<?> clazz, String fieldName) throws Exception {
        try {
            Field field = clazz.getField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            logger.trace(e.getMessage(), e);
            return Beans.getAnyDeclaredField(clazz, fieldName);
        }
    }

    private static Method getAnyDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Beans.getAnyDeclaredMethod(superClass, name, parameterTypes);
        }
        catch (NoClassDefFoundError e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw new NoSuchMethodException();
            }
            return Beans.getAnyDeclaredMethod(superClass, name, parameterTypes);
        }
    }

    private static Field getAnyDeclaredField(Class<?> clazz, String fieldName) throws Exception {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            logger.trace(e.getMessage(), e);
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return Beans.getAnyDeclaredField(superClass, fieldName);
        }
    }

    private static void sentinelMethod() {
    }

    static {
        try {
            SENTINEL_ACCESSOR = Accessor.fromMethod(Beans.class.getDeclaredMethod("sentinelMethod", new Class[0]));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        getters = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ConcurrentMap<String, Accessor>>(){

            @Override
            public ConcurrentMap<String, Accessor> load(Class<?> clazz) {
                return new MapMaker().weakValues().makeMap();
            }
        });
    }
}

