/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.instrumentation.api.Message;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.engine.weaving.MessageTemplateImpl;

public class GenericMessageSupplier
extends MessageSupplier {
    private final MessageTemplateImpl template;
    private final String[] resolvedReceiverPathParts;
    private final String[] resolvedArgPathParts;
    private volatile String[] resolvedReturnValuePathParts;
    private final String methodName;

    public static GenericMessageSupplier create(MessageTemplateImpl template, Object receiver, String methodName, Object ... args) {
        String[] resolvedReceiverPathParts = new String[template.getThisPathParts().size()];
        int i = 0;
        for (MessageTemplateImpl.ValuePathPart part : template.getThisPathParts()) {
            resolvedReceiverPathParts[i++] = part.evaluatePart(receiver);
        }
        String[] resolvedArgPathParts = new String[template.getArgPathParts().size()];
        i = 0;
        for (MessageTemplateImpl.ArgPathPart part : template.getArgPathParts()) {
            if (part.getArgNumber() >= args.length) {
                resolvedArgPathParts[i++] = "<requested arg index out of bounds: " + part.getArgNumber() + ">";
                continue;
            }
            resolvedArgPathParts[i++] = part.evaluatePart(args[part.getArgNumber()]);
        }
        return new GenericMessageSupplier(template, resolvedReceiverPathParts, resolvedArgPathParts, methodName);
    }

    private GenericMessageSupplier(MessageTemplateImpl template, String[] resolvedReceiverPathParts, String[] resolvedArgPathParts, String methodName) {
        this.template = template;
        this.resolvedReceiverPathParts = resolvedReceiverPathParts;
        this.resolvedArgPathParts = resolvedArgPathParts;
        this.methodName = methodName;
    }

    private void setReturnValue(@Nullable Object returnValue) {
        String[] parts = new String[this.template.getReturnPathParts().size()];
        int i = 0;
        for (MessageTemplateImpl.ValuePathPart part : this.template.getReturnPathParts()) {
            parts[i++] = part.evaluatePart(returnValue);
        }
        this.resolvedReturnValuePathParts = parts;
    }

    @Override
    public Message get() {
        return Message.create(this.getMessageText());
    }

    public String getMessageText() {
        StringBuilder sb = new StringBuilder();
        int receiverPathPartIndex = 0;
        int argPathPartIndex = 0;
        int returnValuePathPartIndex = 0;
        block7: for (MessageTemplateImpl.Part part : this.template.getAllParts()) {
            MessageTemplateImpl.PartType partType = part.getType();
            switch (partType) {
                case CONSTANT: {
                    sb.append(((MessageTemplateImpl.ConstantPart)part).getConstant());
                    continue block7;
                }
                case THIS_PATH: {
                    sb.append(this.resolvedReceiverPathParts[receiverPathPartIndex++]);
                    continue block7;
                }
                case ARG_PATH: {
                    sb.append(this.resolvedArgPathParts[argPathPartIndex++]);
                    continue block7;
                }
                case RETURN_PATH: {
                    if (this.resolvedReturnValuePathParts == null) continue block7;
                    sb.append(this.resolvedReturnValuePathParts[returnValuePathPartIndex++]);
                    continue block7;
                }
                case METHOD_NAME: {
                    sb.append(this.methodName);
                    continue block7;
                }
            }
            throw new AssertionError((Object)("Unknown PartType enum: " + (Object)((Object)partType)));
        }
        return sb.toString();
    }

    public static void updateWithReturnValue(Span span, @Nullable Object returnValue) {
        GenericMessageSupplier messageSupplier = (GenericMessageSupplier)span.getMessageSupplier();
        if (messageSupplier != null) {
            messageSupplier.setReturnValue(returnValue);
        }
    }
}

