/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import java.util.ArrayList;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetail;
import org.immutables.value.Generated;

@Generated(from="InstrumentationDetail.BindAnnotation", generator="Immutables")
public final class ImmutableBindAnnotation
extends InstrumentationDetail.BindAnnotation {
    private final Type type;
    private final int argIndex;

    private ImmutableBindAnnotation(Type type, int argIndex) {
        this.type = type;
        this.argIndex = argIndex;
    }

    @Override
    Type type() {
        return this.type;
    }

    @Override
    int argIndex() {
        return this.argIndex;
    }

    public final ImmutableBindAnnotation withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value, "type");
        return new ImmutableBindAnnotation(newValue, this.argIndex);
    }

    public final ImmutableBindAnnotation withArgIndex(int value) {
        if (this.argIndex == value) {
            return this;
        }
        return new ImmutableBindAnnotation(this.type, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBindAnnotation && this.equalTo((ImmutableBindAnnotation)another);
    }

    private boolean equalTo(ImmutableBindAnnotation another) {
        return this.type.equals(another.type) && this.argIndex == another.argIndex;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.argIndex;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("BindAnnotation").omitNullValues().add("type", this.type).add("argIndex", this.argIndex).toString();
    }

    public static ImmutableBindAnnotation copyOf(InstrumentationDetail.BindAnnotation instance) {
        if (instance instanceof ImmutableBindAnnotation) {
            return (ImmutableBindAnnotation)instance;
        }
        return ImmutableBindAnnotation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationDetail.BindAnnotation", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_ARG_INDEX = 2L;
        private long initBits = 3L;
        private Type type;
        private int argIndex;

        private Builder() {
        }

        public final Builder from(InstrumentationDetail.BindAnnotation instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.type(instance.type());
            this.argIndex(instance.argIndex());
            return this;
        }

        public final Builder type(Type type) {
            this.type = Preconditions.checkNotNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder argIndex(int argIndex) {
            this.argIndex = argIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBindAnnotation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBindAnnotation(this.type, this.argIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("argIndex");
            }
            return "Cannot build BindAnnotation, some of required attributes are not set " + attributes;
        }
    }
}

