/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.glowroot.instrumentation.engine.weaving.MixinType;
import org.immutables.value.Generated;

@Generated(from="MixinType", generator="Immutables")
final class ImmutableMixinType
extends MixinType {
    private final ImmutableList<String> targets;
    private final ImmutableList<Type> interfaces;
    @Nullable
    private final String initMethodName;
    private final byte[] implementationBytes;

    private ImmutableMixinType(ImmutableList<String> targets, ImmutableList<Type> interfaces, @Nullable String initMethodName, byte[] implementationBytes) {
        this.targets = targets;
        this.interfaces = interfaces;
        this.initMethodName = initMethodName;
        this.implementationBytes = implementationBytes;
    }

    @Override
    ImmutableList<String> targets() {
        return this.targets;
    }

    @Override
    ImmutableList<Type> interfaces() {
        return this.interfaces;
    }

    @Override
    @Nullable
    String initMethodName() {
        return this.initMethodName;
    }

    @Override
    byte[] implementationBytes() {
        return (byte[])this.implementationBytes.clone();
    }

    public final ImmutableMixinType withTargets(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMixinType(newValue, this.interfaces, this.initMethodName, this.implementationBytes);
    }

    public final ImmutableMixinType withTargets(Iterable<String> elements) {
        if (this.targets == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMixinType(newValue, this.interfaces, this.initMethodName, this.implementationBytes);
    }

    public final ImmutableMixinType withInterfaces(Type ... elements) {
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMixinType(this.targets, newValue, this.initMethodName, this.implementationBytes);
    }

    public final ImmutableMixinType withInterfaces(Iterable<? extends Type> elements) {
        if (this.interfaces == elements) {
            return this;
        }
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableMixinType(this.targets, newValue, this.initMethodName, this.implementationBytes);
    }

    public final ImmutableMixinType withInitMethodName(@Nullable String value) {
        if (Objects.equal(this.initMethodName, value)) {
            return this;
        }
        return new ImmutableMixinType(this.targets, this.interfaces, value, this.implementationBytes);
    }

    public final ImmutableMixinType withImplementationBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableMixinType(this.targets, this.interfaces, this.initMethodName, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMixinType && this.equalTo((ImmutableMixinType)another);
    }

    private boolean equalTo(ImmutableMixinType another) {
        return this.targets.equals(another.targets) && this.interfaces.equals(another.interfaces) && Objects.equal(this.initMethodName, another.initMethodName) && Arrays.equals(this.implementationBytes, another.implementationBytes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.targets.hashCode();
        h += (h << 5) + this.interfaces.hashCode();
        h += (h << 5) + Objects.hashCode(this.initMethodName);
        h += (h << 5) + Arrays.hashCode(this.implementationBytes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MixinType").omitNullValues().add("targets", this.targets).add("interfaces", this.interfaces).add("initMethodName", this.initMethodName).add("implementationBytes", Arrays.toString(this.implementationBytes)).toString();
    }

    public static ImmutableMixinType copyOf(MixinType instance) {
        if (instance instanceof ImmutableMixinType) {
            return (ImmutableMixinType)instance;
        }
        return ImmutableMixinType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MixinType", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_IMPLEMENTATION_BYTES = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<String> targets = ImmutableList.builder();
        private ImmutableList.Builder<Type> interfaces = ImmutableList.builder();
        private String initMethodName;
        private byte[] implementationBytes;

        private Builder() {
        }

        public final Builder from(MixinType instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.addAllTargets(instance.targets());
            this.addAllInterfaces(instance.interfaces());
            String initMethodNameValue = instance.initMethodName();
            if (initMethodNameValue != null) {
                this.initMethodName(initMethodNameValue);
            }
            this.implementationBytes(instance.implementationBytes());
            return this;
        }

        public final Builder addTargets(String element) {
            this.targets.add((Object)element);
            return this;
        }

        public final Builder addTargets(String ... elements) {
            this.targets.add(elements);
            return this;
        }

        public final Builder targets(Iterable<String> elements) {
            this.targets = ImmutableList.builder();
            return this.addAllTargets(elements);
        }

        public final Builder addAllTargets(Iterable<String> elements) {
            this.targets.addAll((Iterable)elements);
            return this;
        }

        public final Builder addInterfaces(Type element) {
            this.interfaces.add((Object)element);
            return this;
        }

        public final Builder addInterfaces(Type ... elements) {
            this.interfaces.add(elements);
            return this;
        }

        public final Builder interfaces(Iterable<? extends Type> elements) {
            this.interfaces = ImmutableList.builder();
            return this.addAllInterfaces(elements);
        }

        public final Builder addAllInterfaces(Iterable<? extends Type> elements) {
            this.interfaces.addAll(elements);
            return this;
        }

        public final Builder initMethodName(@Nullable String initMethodName) {
            this.initMethodName = initMethodName;
            return this;
        }

        public final Builder implementationBytes(byte ... implementationBytes) {
            this.implementationBytes = (byte[])implementationBytes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMixinType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMixinType((ImmutableList)this.targets.build(), (ImmutableList)this.interfaces.build(), this.initMethodName, this.implementationBytes);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("implementationBytes");
            }
            return "Cannot build MixinType, some of required attributes are not set " + attributes;
        }
    }
}

