/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Booleans;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetail;
import org.immutables.value.Generated;

@Generated(from="InstrumentationDetail.PointcutClass", generator="Immutables")
public final class ImmutablePointcutClass
extends InstrumentationDetail.PointcutClass {
    private final Type type;
    private final Advice.Pointcut pointcut;
    private final ImmutableList<InstrumentationDetail.PointcutMethod> methods;
    private final byte[] bytes;
    private final boolean collocateInClassLoader;
    @Nullable
    private final File jarFile;

    private ImmutablePointcutClass(Type type, Advice.Pointcut pointcut, ImmutableList<InstrumentationDetail.PointcutMethod> methods, byte[] bytes, boolean collocateInClassLoader, @Nullable File jarFile) {
        this.type = type;
        this.pointcut = pointcut;
        this.methods = methods;
        this.bytes = bytes;
        this.collocateInClassLoader = collocateInClassLoader;
        this.jarFile = jarFile;
    }

    @Override
    Type type() {
        return this.type;
    }

    @Override
    Advice.Pointcut pointcut() {
        return this.pointcut;
    }

    ImmutableList<InstrumentationDetail.PointcutMethod> methods() {
        return this.methods;
    }

    @Override
    byte[] bytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    boolean collocateInClassLoader() {
        return this.collocateInClassLoader;
    }

    @Override
    @Nullable
    File jarFile() {
        return this.jarFile;
    }

    public final ImmutablePointcutClass withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value, "type");
        return new ImmutablePointcutClass(newValue, this.pointcut, this.methods, this.bytes, this.collocateInClassLoader, this.jarFile);
    }

    public final ImmutablePointcutClass withPointcut(Advice.Pointcut value) {
        if (this.pointcut == value) {
            return this;
        }
        Advice.Pointcut newValue = Preconditions.checkNotNull(value, "pointcut");
        return new ImmutablePointcutClass(this.type, newValue, this.methods, this.bytes, this.collocateInClassLoader, this.jarFile);
    }

    public final ImmutablePointcutClass withMethods(InstrumentationDetail.PointcutMethod ... elements) {
        ImmutableList<InstrumentationDetail.PointcutMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePointcutClass(this.type, this.pointcut, newValue, this.bytes, this.collocateInClassLoader, this.jarFile);
    }

    public final ImmutablePointcutClass withMethods(Iterable<? extends InstrumentationDetail.PointcutMethod> elements) {
        if (this.methods == elements) {
            return this;
        }
        ImmutableList<InstrumentationDetail.PointcutMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutablePointcutClass(this.type, this.pointcut, newValue, this.bytes, this.collocateInClassLoader, this.jarFile);
    }

    public final ImmutablePointcutClass withBytes(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, newValue, this.collocateInClassLoader, this.jarFile);
    }

    public final ImmutablePointcutClass withCollocateInClassLoader(boolean value) {
        if (this.collocateInClassLoader == value) {
            return this;
        }
        return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, this.bytes, value, this.jarFile);
    }

    public final ImmutablePointcutClass withJarFile(@Nullable File value) {
        if (this.jarFile == value) {
            return this;
        }
        return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, this.bytes, this.collocateInClassLoader, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePointcutClass && this.equalTo((ImmutablePointcutClass)another);
    }

    private boolean equalTo(ImmutablePointcutClass another) {
        return this.type.equals(another.type) && this.pointcut.equals(another.pointcut) && this.methods.equals(another.methods) && Arrays.equals(this.bytes, another.bytes) && this.collocateInClassLoader == another.collocateInClassLoader && Objects.equal(this.jarFile, another.jarFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.pointcut.hashCode();
        h += (h << 5) + this.methods.hashCode();
        h += (h << 5) + Arrays.hashCode(this.bytes);
        h += (h << 5) + Booleans.hashCode(this.collocateInClassLoader);
        h += (h << 5) + Objects.hashCode(this.jarFile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PointcutClass").omitNullValues().add("type", this.type).add("pointcut", this.pointcut).add("methods", this.methods).add("bytes", Arrays.toString(this.bytes)).add("collocateInClassLoader", this.collocateInClassLoader).add("jarFile", this.jarFile).toString();
    }

    public static ImmutablePointcutClass copyOf(InstrumentationDetail.PointcutClass instance) {
        if (instance instanceof ImmutablePointcutClass) {
            return (ImmutablePointcutClass)instance;
        }
        return ImmutablePointcutClass.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationDetail.PointcutClass", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_POINTCUT = 2L;
        private static final long INIT_BIT_BYTES = 4L;
        private static final long INIT_BIT_COLLOCATE_IN_CLASS_LOADER = 8L;
        private long initBits = 15L;
        private Type type;
        private Advice.Pointcut pointcut;
        private ImmutableList.Builder<InstrumentationDetail.PointcutMethod> methods = ImmutableList.builder();
        private byte[] bytes;
        private boolean collocateInClassLoader;
        private File jarFile;

        private Builder() {
        }

        public final Builder from(InstrumentationDetail.PointcutClass instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.type(instance.type());
            this.pointcut(instance.pointcut());
            this.addAllMethods(instance.methods());
            this.bytes(instance.bytes());
            this.collocateInClassLoader(instance.collocateInClassLoader());
            File jarFileValue = instance.jarFile();
            if (jarFileValue != null) {
                this.jarFile(jarFileValue);
            }
            return this;
        }

        public final Builder type(Type type) {
            this.type = Preconditions.checkNotNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pointcut(Advice.Pointcut pointcut) {
            this.pointcut = Preconditions.checkNotNull(pointcut, "pointcut");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addMethods(InstrumentationDetail.PointcutMethod element) {
            this.methods.add((Object)element);
            return this;
        }

        public final Builder addMethods(InstrumentationDetail.PointcutMethod ... elements) {
            this.methods.add(elements);
            return this;
        }

        public final Builder methods(Iterable<? extends InstrumentationDetail.PointcutMethod> elements) {
            this.methods = ImmutableList.builder();
            return this.addAllMethods(elements);
        }

        public final Builder addAllMethods(Iterable<? extends InstrumentationDetail.PointcutMethod> elements) {
            this.methods.addAll(elements);
            return this;
        }

        public final Builder bytes(byte ... bytes) {
            this.bytes = (byte[])bytes.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder collocateInClassLoader(boolean collocateInClassLoader) {
            this.collocateInClassLoader = collocateInClassLoader;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder jarFile(@Nullable File jarFile) {
            this.jarFile = jarFile;
            return this;
        }

        public ImmutablePointcutClass build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePointcutClass(this.type, this.pointcut, (ImmutableList)this.methods.build(), this.bytes, this.collocateInClassLoader, this.jarFile);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pointcut");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bytes");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("collocateInClassLoader");
            }
            return "Cannot build PointcutClass, some of required attributes are not set " + attributes;
        }
    }
}

