/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import java.util.ArrayList;
import org.glowroot.instrumentation.engine.weaving.ThinClassVisitor;
import org.immutables.value.Generated;

@Generated(from="ThinClassVisitor.ThinClass", generator="Immutables")
final class ImmutableThinClass
implements ThinClassVisitor.ThinClass {
    private final int access;
    private final String name;
    @Nullable
    private final String superName;
    private final ImmutableList<String> interfaces;
    private final ImmutableList<String> annotations;
    private final ImmutableList<ThinClassVisitor.ThinMethod> nonBridgeMethods;
    private final ImmutableList<ThinClassVisitor.ThinMethod> bridgeMethods;
    private final ImmutableList<Type> ejbRemoteInterfaces;

    private ImmutableThinClass(int access, String name, @Nullable String superName, ImmutableList<String> interfaces, ImmutableList<String> annotations, ImmutableList<ThinClassVisitor.ThinMethod> nonBridgeMethods, ImmutableList<ThinClassVisitor.ThinMethod> bridgeMethods, ImmutableList<Type> ejbRemoteInterfaces) {
        this.access = access;
        this.name = name;
        this.superName = superName;
        this.interfaces = interfaces;
        this.annotations = annotations;
        this.nonBridgeMethods = nonBridgeMethods;
        this.bridgeMethods = bridgeMethods;
        this.ejbRemoteInterfaces = ejbRemoteInterfaces;
    }

    @Override
    public int access() {
        return this.access;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String superName() {
        return this.superName;
    }

    public ImmutableList<String> interfaces() {
        return this.interfaces;
    }

    public ImmutableList<String> annotations() {
        return this.annotations;
    }

    public ImmutableList<ThinClassVisitor.ThinMethod> nonBridgeMethods() {
        return this.nonBridgeMethods;
    }

    public ImmutableList<ThinClassVisitor.ThinMethod> bridgeMethods() {
        return this.bridgeMethods;
    }

    public ImmutableList<Type> ejbRemoteInterfaces() {
        return this.ejbRemoteInterfaces;
    }

    public final ImmutableThinClass withAccess(int value) {
        if (this.access == value) {
            return this;
        }
        return new ImmutableThinClass(value, this.name, this.superName, this.interfaces, this.annotations, this.nonBridgeMethods, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableThinClass(this.access, newValue, this.superName, this.interfaces, this.annotations, this.nonBridgeMethods, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withSuperName(@Nullable String value) {
        if (Objects.equal(this.superName, value)) {
            return this;
        }
        return new ImmutableThinClass(this.access, this.name, value, this.interfaces, this.annotations, this.nonBridgeMethods, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withInterfaces(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, newValue, this.annotations, this.nonBridgeMethods, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withInterfaces(Iterable<String> elements) {
        if (this.interfaces == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, newValue, this.annotations, this.nonBridgeMethods, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withAnnotations(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, newValue, this.nonBridgeMethods, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withAnnotations(Iterable<String> elements) {
        if (this.annotations == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, newValue, this.nonBridgeMethods, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withNonBridgeMethods(ThinClassVisitor.ThinMethod ... elements) {
        ImmutableList<ThinClassVisitor.ThinMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, this.annotations, newValue, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withNonBridgeMethods(Iterable<? extends ThinClassVisitor.ThinMethod> elements) {
        if (this.nonBridgeMethods == elements) {
            return this;
        }
        ImmutableList<ThinClassVisitor.ThinMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, this.annotations, newValue, this.bridgeMethods, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withBridgeMethods(ThinClassVisitor.ThinMethod ... elements) {
        ImmutableList<ThinClassVisitor.ThinMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, this.annotations, this.nonBridgeMethods, newValue, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withBridgeMethods(Iterable<? extends ThinClassVisitor.ThinMethod> elements) {
        if (this.bridgeMethods == elements) {
            return this;
        }
        ImmutableList<ThinClassVisitor.ThinMethod> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, this.annotations, this.nonBridgeMethods, newValue, this.ejbRemoteInterfaces);
    }

    public final ImmutableThinClass withEjbRemoteInterfaces(Type ... elements) {
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, this.annotations, this.nonBridgeMethods, this.bridgeMethods, newValue);
    }

    public final ImmutableThinClass withEjbRemoteInterfaces(Iterable<? extends Type> elements) {
        if (this.ejbRemoteInterfaces == elements) {
            return this;
        }
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new ImmutableThinClass(this.access, this.name, this.superName, this.interfaces, this.annotations, this.nonBridgeMethods, this.bridgeMethods, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThinClass && this.equalTo((ImmutableThinClass)another);
    }

    private boolean equalTo(ImmutableThinClass another) {
        return this.access == another.access && this.name.equals(another.name) && Objects.equal(this.superName, another.superName) && this.interfaces.equals(another.interfaces) && this.annotations.equals(another.annotations) && this.nonBridgeMethods.equals(another.nonBridgeMethods) && this.bridgeMethods.equals(another.bridgeMethods) && this.ejbRemoteInterfaces.equals(another.ejbRemoteInterfaces);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.access;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.superName);
        h += (h << 5) + this.interfaces.hashCode();
        h += (h << 5) + this.annotations.hashCode();
        h += (h << 5) + this.nonBridgeMethods.hashCode();
        h += (h << 5) + this.bridgeMethods.hashCode();
        h += (h << 5) + this.ejbRemoteInterfaces.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThinClass").omitNullValues().add("access", this.access).add("name", this.name).add("superName", this.superName).add("interfaces", this.interfaces).add("annotations", this.annotations).add("nonBridgeMethods", this.nonBridgeMethods).add("bridgeMethods", this.bridgeMethods).add("ejbRemoteInterfaces", this.ejbRemoteInterfaces).toString();
    }

    public static ImmutableThinClass copyOf(ThinClassVisitor.ThinClass instance) {
        if (instance instanceof ImmutableThinClass) {
            return (ImmutableThinClass)instance;
        }
        return ImmutableThinClass.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ThinClassVisitor.ThinClass", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACCESS = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private int access;
        private String name;
        private String superName;
        private ImmutableList.Builder<String> interfaces = ImmutableList.builder();
        private ImmutableList.Builder<String> annotations = ImmutableList.builder();
        private ImmutableList.Builder<ThinClassVisitor.ThinMethod> nonBridgeMethods = ImmutableList.builder();
        private ImmutableList.Builder<ThinClassVisitor.ThinMethod> bridgeMethods = ImmutableList.builder();
        private ImmutableList.Builder<Type> ejbRemoteInterfaces = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(ThinClassVisitor.ThinClass instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.access(instance.access());
            this.name(instance.name());
            String superNameValue = instance.superName();
            if (superNameValue != null) {
                this.superName(superNameValue);
            }
            this.addAllInterfaces(instance.interfaces());
            this.addAllAnnotations(instance.annotations());
            this.addAllNonBridgeMethods(instance.nonBridgeMethods());
            this.addAllBridgeMethods(instance.bridgeMethods());
            this.addAllEjbRemoteInterfaces(instance.ejbRemoteInterfaces());
            return this;
        }

        public final Builder access(int access) {
            this.access = access;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder superName(@Nullable String superName) {
            this.superName = superName;
            return this;
        }

        public final Builder addInterfaces(String element) {
            this.interfaces.add((Object)element);
            return this;
        }

        public final Builder addInterfaces(String ... elements) {
            this.interfaces.add(elements);
            return this;
        }

        public final Builder interfaces(Iterable<String> elements) {
            this.interfaces = ImmutableList.builder();
            return this.addAllInterfaces(elements);
        }

        public final Builder addAllInterfaces(Iterable<String> elements) {
            this.interfaces.addAll((Iterable)elements);
            return this;
        }

        public final Builder addAnnotations(String element) {
            this.annotations.add((Object)element);
            return this;
        }

        public final Builder addAnnotations(String ... elements) {
            this.annotations.add(elements);
            return this;
        }

        public final Builder annotations(Iterable<String> elements) {
            this.annotations = ImmutableList.builder();
            return this.addAllAnnotations(elements);
        }

        public final Builder addAllAnnotations(Iterable<String> elements) {
            this.annotations.addAll((Iterable)elements);
            return this;
        }

        public final Builder addNonBridgeMethods(ThinClassVisitor.ThinMethod element) {
            this.nonBridgeMethods.add((Object)element);
            return this;
        }

        public final Builder addNonBridgeMethods(ThinClassVisitor.ThinMethod ... elements) {
            this.nonBridgeMethods.add(elements);
            return this;
        }

        public final Builder nonBridgeMethods(Iterable<? extends ThinClassVisitor.ThinMethod> elements) {
            this.nonBridgeMethods = ImmutableList.builder();
            return this.addAllNonBridgeMethods(elements);
        }

        public final Builder addAllNonBridgeMethods(Iterable<? extends ThinClassVisitor.ThinMethod> elements) {
            this.nonBridgeMethods.addAll(elements);
            return this;
        }

        public final Builder addBridgeMethods(ThinClassVisitor.ThinMethod element) {
            this.bridgeMethods.add((Object)element);
            return this;
        }

        public final Builder addBridgeMethods(ThinClassVisitor.ThinMethod ... elements) {
            this.bridgeMethods.add(elements);
            return this;
        }

        public final Builder bridgeMethods(Iterable<? extends ThinClassVisitor.ThinMethod> elements) {
            this.bridgeMethods = ImmutableList.builder();
            return this.addAllBridgeMethods(elements);
        }

        public final Builder addAllBridgeMethods(Iterable<? extends ThinClassVisitor.ThinMethod> elements) {
            this.bridgeMethods.addAll(elements);
            return this;
        }

        public final Builder addEjbRemoteInterfaces(Type element) {
            this.ejbRemoteInterfaces.add((Object)element);
            return this;
        }

        public final Builder addEjbRemoteInterfaces(Type ... elements) {
            this.ejbRemoteInterfaces.add(elements);
            return this;
        }

        public final Builder ejbRemoteInterfaces(Iterable<? extends Type> elements) {
            this.ejbRemoteInterfaces = ImmutableList.builder();
            return this.addAllEjbRemoteInterfaces(elements);
        }

        public final Builder addAllEjbRemoteInterfaces(Iterable<? extends Type> elements) {
            this.ejbRemoteInterfaces.addAll(elements);
            return this;
        }

        public ImmutableThinClass build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableThinClass(this.access, this.name, this.superName, (ImmutableList)this.interfaces.build(), (ImmutableList)this.annotations.build(), (ImmutableList)this.nonBridgeMethods.build(), (ImmutableList)this.bridgeMethods.build(), (ImmutableList)this.ejbRemoteInterfaces.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("access");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ThinClass, some of required attributes are not set " + attributes;
        }
    }
}

