/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.regex.Pattern;

class MaybePatterns {
    private MaybePatterns() {
    }

    @Nullable
    static Pattern buildPattern(String maybePattern) {
        if (maybePattern.startsWith("/") && maybePattern.endsWith("/")) {
            return Pattern.compile(maybePattern.substring(1, maybePattern.length() - 1));
        }
        if (maybePattern.contains("|")) {
            Object[] parts = maybePattern.split("\\|");
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = MaybePatterns.buildSimplePattern((String)parts[i]);
            }
            return Pattern.compile(Joiner.on('|').join(parts));
        }
        if (maybePattern.contains("*")) {
            return Pattern.compile(MaybePatterns.buildSimplePattern(maybePattern));
        }
        return null;
    }

    private static String buildSimplePattern(String part) {
        String pattern = "\\Q" + part.replace("*", "\\E.*\\Q") + "\\E";
        return pattern.replace("\\Q\\E", "");
    }
}

