/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassReader;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassWriter;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.glowroot.instrumentation.engine.weaving.JSRInlinerClassVisitor;
import org.glowroot.instrumentation.engine.weaving.PointcutClassVisitor;

public class PointcutClassFileTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(PointcutClassFileTransformer.class);

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        try {
            ClassWriter cw = new ClassWriter(1);
            PointcutClassVisitor cv = new PointcutClassVisitor(cw);
            ClassReader cr = new ClassReader(bytes);
            cr.accept(new JSRInlinerClassVisitor(cv), 8);
            if (cv.isConstructorPointcut() && cv.hasOnBeforeMethod()) {
                return cw.toByteArray();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }
}

