/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ArrayListMultimap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Multimap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.glowroot.instrumentation.engine.weaving.ImmutablePointcutClassName;
import org.glowroot.instrumentation.engine.weaving.MaybePatterns;
import org.immutables.value.Value;

public class Reweaving {
    private static final Logger logger = LoggerFactory.getLogger(Reweaving.class);

    private Reweaving() {
    }

    public static void initialReweave(Set<PointcutClassName> pointcutClassNames, Class<?>[] initialLoadedClasses, Instrumentation instrumentation, List<String> doNotWeavePrefixes) {
        if (!instrumentation.isRetransformClassesSupported()) {
            return;
        }
        Set<Class<?>> classes = Reweaving.getExistingModifiableSubClasses(pointcutClassNames, initialLoadedClasses, instrumentation, doNotWeavePrefixes);
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) continue;
            try {
                instrumentation.retransformClasses(clazz);
            }
            catch (UnmodifiableClassException e) {
                logger.debug(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> getExistingModifiableSubClasses(Set<PointcutClassName> pointcutClassNames, Class<?>[] classes, Instrumentation instrumentation, List<String> doNotWeavePrefixes) {
        void var8_10;
        ArrayList<Class<?>> matchingClasses = Lists.newArrayList();
        ArrayListMultimap<Class<?>, Class<?>> subClasses = ArrayListMultimap.create();
        Class<?>[] classArray = classes;
        int n = classArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            Class<?> clazz = classArray[var8_10];
            String className = clazz.getName();
            if (!Reweaving.ignoreClass(className, doNotWeavePrefixes) && instrumentation.isModifiableClass(clazz)) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass != null) {
                    subClasses.put(superclass, clazz);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    subClasses.put(iface, clazz);
                }
                for (PointcutClassName pointcutClassName : pointcutClassNames) {
                    if (!pointcutClassName.appliesTo(clazz.getName())) continue;
                    matchingClasses.add(clazz);
                    break;
                }
            }
            ++var8_10;
        }
        HashSet<Class<?>> matchingSubClasses = Sets.newHashSet();
        for (Class clazz : matchingClasses) {
            Reweaving.addToMatchingSubClasses(clazz, matchingSubClasses, subClasses);
        }
        return matchingSubClasses;
    }

    private static void addToMatchingSubClasses(Class<?> clazz, Set<Class<?>> matchingSubClasses, Multimap<Class<?>, Class<?>> subClasses) {
        matchingSubClasses.add(clazz);
        for (Class<?> subClass : subClasses.get(clazz)) {
            Reweaving.addToMatchingSubClasses(subClass, matchingSubClasses, subClasses);
        }
    }

    private static boolean ignoreClass(String className, List<String> doNotWeavePrefixes) {
        if (Reweaving.isEngineClass(className)) {
            return true;
        }
        for (String doNotWeavePrefix : doNotWeavePrefixes) {
            if (!className.startsWith(doNotWeavePrefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEngineClass(String className) {
        return className.startsWith("org.glowroot.instrumentation.engine.") || className.startsWith("org.glowroot.instrumentation.api.");
    }

    @Value.Immutable
    public static abstract class PointcutClassName {
        @Nullable
        abstract Pattern pattern();

        @Nullable
        abstract String nonPattern();

        @Nullable
        abstract PointcutClassName subTypeRestriction();

        abstract boolean doNotMatchSubClasses();

        public static PointcutClassName fromMaybePattern(String maybePattern, @Nullable PointcutClassName subTypeRestriction, boolean doNotMatchSubClasses) {
            Pattern pattern = MaybePatterns.buildPattern(maybePattern);
            if (pattern == null) {
                return PointcutClassName.fromNonPattern(maybePattern, subTypeRestriction, doNotMatchSubClasses);
            }
            return PointcutClassName.fromPattern(pattern, subTypeRestriction, doNotMatchSubClasses);
        }

        public static PointcutClassName fromPattern(Pattern pattern, @Nullable PointcutClassName subTypeRestrictionPointcutClassName, boolean doNotMatchSubClasses) {
            return ImmutablePointcutClassName.builder().pattern(pattern).nonPattern(null).subTypeRestriction(subTypeRestrictionPointcutClassName).doNotMatchSubClasses(doNotMatchSubClasses).build();
        }

        public static PointcutClassName fromNonPattern(String nonPattern, @Nullable PointcutClassName subTypeRestrictionPointcutClassName, boolean doNotMatchSubClasses) {
            return ImmutablePointcutClassName.builder().pattern(null).nonPattern(nonPattern).subTypeRestriction(subTypeRestrictionPointcutClassName).doNotMatchSubClasses(doNotMatchSubClasses).build();
        }

        private boolean appliesTo(String className) {
            PointcutClassName subTypeRestriction = this.subTypeRestriction();
            if (subTypeRestriction != null && !subTypeRestriction.appliesTo(className)) {
                return false;
            }
            Pattern pattern = this.pattern();
            if (pattern != null) {
                return pattern.matcher(className).matches();
            }
            return Preconditions.checkNotNull(this.nonPattern()).equals(className);
        }
    }
}

