/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import org.glowroot.instrumentation.api.weaving.Shim;
import org.glowroot.instrumentation.engine.weaving.ImmutableShimType;
import org.immutables.value.Value;

@Value.Immutable
abstract class ShimType {
    ShimType() {
    }

    static ShimType create(Shim shim, Class<?> iface) {
        ImmutableShimType.Builder builder = ImmutableShimType.builder();
        builder.addTargets(shim.value());
        builder.iface(Type.getType(iface));
        for (Method method : iface.getMethods()) {
            if (!method.isAnnotationPresent(Shim.class)) continue;
            builder.addShimMethods(method);
        }
        return builder.build();
    }

    abstract Type iface();

    abstract ImmutableList<String> targets();

    abstract ImmutableList<Method> shimMethods();
}

