/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.glowroot.instrumentation.engine.weaving.Java9;
import org.glowroot.instrumentation.engine.weaving.Weaver;

public class WeavingClassFileTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(WeavingClassFileTransformer.class);
    private final Weaver weaver;
    private final Instrumentation instrumentation;
    private final List<String> doNotWeavePrefixes;
    private final boolean weaveBootstrapClassLoader;
    private final Set<Object> redefinedModules = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));

    public WeavingClassFileTransformer(Weaver weaver, Instrumentation instrumentation, List<String> doNotWeavePrefixes) {
        this.weaver = weaver;
        this.instrumentation = instrumentation;
        this.doNotWeavePrefixes = doNotWeavePrefixes;
        this.weaveBootstrapClassLoader = WeavingClassFileTransformer.isInBootstrapClassLoader();
    }

    public byte[] transformJava9(Object module, @Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        if (this.redefinedModules.add(module)) {
            try {
                Java9.grantAccessToEngine(this.instrumentation, module);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
        return this.transform(loader, className, classBeingRedefined, protectionDomain, bytes);
    }

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        String nonNullClassName = className == null ? "unnamed" : className;
        try {
            return this.transformInternal(loader, nonNullClassName, classBeingRedefined, protectionDomain, bytes);
        }
        catch (Throwable t) {
            logger.error("error weaving {}: {}", nonNullClassName, t.getMessage(), t);
            return null;
        }
    }

    private byte[] transformInternal(@Nullable ClassLoader loader, String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        if (this.ignoreClass(className, loader)) {
            return null;
        }
        if (loader == null && !this.weaveBootstrapClassLoader) {
            return null;
        }
        CodeSource codeSource = protectionDomain == null ? null : protectionDomain.getCodeSource();
        return this.weaver.weave(bytes, className, classBeingRedefined, codeSource, loader);
    }

    private boolean ignoreClass(String className, @Nullable ClassLoader loader) {
        if (WeavingClassFileTransformer.isEngineClass(className)) {
            return true;
        }
        for (String doNotWeavePrefix : this.doNotWeavePrefixes) {
            if (!className.startsWith(doNotWeavePrefix)) continue;
            return true;
        }
        if (className.startsWith("sun/reflect/Generated")) {
            return true;
        }
        return className.equals("load/C4") && loader != null && loader.getClass().getName().equals("oracle.classloader.util.ClassLoadEnvironment$DependencyLoader");
    }

    private static boolean isEngineClass(String className) {
        return className.startsWith("org/glowroot/instrumentation/engine/") || className.startsWith("org/glowroot/instrumentation/api/");
    }

    private static boolean isInBootstrapClassLoader() {
        return WeavingClassFileTransformer.class.getClassLoader() == null;
    }
}

