/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jaxrs;

import java.util.List;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.jaxrs.ResourceMethodMeta;

public class JaxrsInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("jaxrs resource");
    private static final BooleanProperty useAltTransactionNaming = Agent.getConfigService("jaxrs").getBooleanProperty("useAltTransactionNaming");

    private static String getTransactionName(String path, @Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
        if (servletRequestInfo == null) {
            return path;
        }
        String method = servletRequestInfo.getMethod();
        String servletPath = JaxrsInstrumentation.getServletPath(servletRequestInfo);
        if (method.isEmpty()) {
            return servletPath + path;
        }
        return method + " " + servletPath + path;
    }

    private static String getServletPath(ThreadContext.ServletRequestInfo servletRequestInfo) {
        if (servletRequestInfo.getPathInfo() == null) {
            return servletRequestInfo.getContextPath();
        }
        return servletRequestInfo.getContextPath() + servletRequestInfo.getServletPath();
    }

    @Advice.Pointcut(methodAnnotation="javax.ws.rs.Path|javax.ws.rs.DELETE|javax.ws.rs.GET|javax.ws.rs.HEAD|javax.ws.rs.OPTIONS|javax.ws.rs.POST|javax.ws.rs.PUT", methodParameterTypes={".."}, nestingGroup="jaxrs")
    public static class ResourceAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.MethodMeta ResourceMethodMeta resourceMethodMeta, ThreadContext context) {
            ThreadContext.ServletRequestInfo servletRequestInfo;
            if (resourceMethodMeta.hasHttpMethodAnnotation()) {
                if (useAltTransactionNaming.value()) {
                    context.setTransactionName(resourceMethodMeta.getAltTransactionName(), -100);
                } else {
                    ThreadContext.ServletRequestInfo servletRequestInfo2 = context.getServletRequestInfo();
                    if (servletRequestInfo2 != null) {
                        List<String> jaxRsParts = servletRequestInfo2.getJaxRsParts();
                        String path = resourceMethodMeta.getPath();
                        if (!jaxRsParts.isEmpty()) {
                            StringBuilder sb = new StringBuilder();
                            for (String jaxRsPart : jaxRsParts) {
                                sb.append(jaxRsPart);
                            }
                            sb.append(path);
                            path = sb.toString();
                        }
                        String transactionName = JaxrsInstrumentation.getTransactionName(path, servletRequestInfo2);
                        context.setTransactionName(transactionName, -100);
                    }
                }
                return context.startLocalSpan(MessageSupplier.create("jaxrs resource: {}.{}()", resourceMethodMeta.getResourceClassName(), resourceMethodMeta.getMethodName()), TIMER_NAME);
            }
            if (!useAltTransactionNaming.value() && (servletRequestInfo = context.getServletRequestInfo()) != null) {
                servletRequestInfo.addJaxRsPart(resourceMethodMeta.getPath());
            }
            return null;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.end();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.endWithError(t);
            }
        }
    }
}

