/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;
import org.glowroot.instrumentation.jdbc.ConnectionInstrumentation;
import org.glowroot.instrumentation.jdbc.boot.BatchPreparedStatementMessageSupplier;
import org.glowroot.instrumentation.jdbc.boot.BatchPreparedStatementMessageSupplier2;
import org.glowroot.instrumentation.jdbc.boot.JdbcInstrumentationProperties;
import org.glowroot.instrumentation.jdbc.boot.PreparedStatementMessageSupplier;
import org.glowroot.instrumentation.jdbc.boot.PreparedStatementMirror;
import org.glowroot.instrumentation.jdbc.boot.StatementMessageSupplier;
import org.glowroot.instrumentation.jdbc.boot.StatementMirror;

public class StatementInstrumentation {
    private static final Logger logger = Logger.getLogger(StatementInstrumentation.class);
    private static final TimerName QUERY_TIMER_NAME = Agent.getTimerName("jdbc query");
    private static final TimerName STATEMENT_CLOSE_TIMER_NAME = Agent.getTimerName("jdbc statement close");
    private static final String QUERY_TYPE = "SQL";
    private static final QueryMessageSupplier BATCH_STATEMENT_MESSAGE_SUPPLIER = QueryMessageSupplier.create(Collections.singletonMap("batchStatement", true));
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static final BooleanProperty captureStatementClose = configService.getBooleanProperty("captureStatementClose");
    private static boolean captureBindParameters;
    private static final AtomicBoolean explainPlanExceptionLogged;
    private static final AtomicBoolean explainPlanMultipleRowsLogged;

    @Nullable
    private static QuerySpan onBeforeStatement(HasStatementMirrorMixin statement, @Nullable String sql, QueryMessageSupplier messageSupplier, ThreadContext context) {
        if (sql == null) {
            return null;
        }
        StatementMirror mirror = statement.glowroot$getStatementMirror();
        if (mirror == null) {
            return null;
        }
        QuerySpan querySpan = context.startQuerySpan(QUERY_TYPE, mirror.getDest(), sql, messageSupplier, QUERY_TIMER_NAME);
        mirror.setLastQuerySpan(querySpan);
        return querySpan;
    }

    private static QuerySpan onBeforePreparedStatement(HasStatementMirrorMixin preparedStatement, ThreadContext context) {
        PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
        String queryText = mirror.getSql();
        QueryMessageSupplier messageSupplier = captureBindParameters ? new PreparedStatementMessageSupplier(mirror.getParameters(), queryText) : QueryMessageSupplier.create();
        QuerySpan querySpan = context.startQuerySpan(QUERY_TYPE, mirror.getDest(), queryText, messageSupplier, QUERY_TIMER_NAME);
        mirror.setLastQuerySpan(querySpan);
        return querySpan;
    }

    private static QuerySpan onBeforeBatchStatement(StatementMirror mirror, ThreadContext context) {
        String concatenated;
        List<String> batchedSql = mirror.getBatchedSql();
        if (batchedSql.isEmpty()) {
            concatenated = "[empty batch statement]";
        } else if (batchedSql.size() == 1) {
            concatenated = batchedSql.get(0);
        } else {
            int len = 0;
            for (String sql : batchedSql) {
                len += sql.length();
            }
            int numSeparators = batchedSql.size() - 1;
            StringBuilder sb = new StringBuilder(len + 2 * numSeparators);
            boolean first = true;
            for (String sql : batchedSql) {
                if (!first) {
                    sb.append("; ");
                }
                sb.append(sql);
                first = false;
            }
            concatenated = sb.toString();
        }
        QuerySpan querySpan = context.startQuerySpan(QUERY_TYPE, mirror.getDest(), concatenated, BATCH_STATEMENT_MESSAGE_SUPPLIER, QUERY_TIMER_NAME);
        mirror.setLastQuerySpan(querySpan);
        mirror.clearBatch();
        return querySpan;
    }

    private static QuerySpan onBeforeBatchPreparedStatement(PreparedStatementMirror mirror, ThreadContext context) {
        String queryText = mirror.getSql();
        int batchCount = mirror.getBatchCount();
        QueryMessageSupplier messageSupplier = batchCount <= 0 ? new BatchPreparedStatementMessageSupplier2(0) : (captureBindParameters ? new BatchPreparedStatementMessageSupplier(mirror.getBatchedParameters(), batchCount) : new BatchPreparedStatementMessageSupplier2(batchCount));
        QuerySpan querySpan = context.startQuerySpan(QUERY_TYPE, mirror.getDest(), queryText, batchCount, messageSupplier, QUERY_TIMER_NAME);
        mirror.setLastQuerySpan(querySpan);
        mirror.clearBatch();
        return querySpan;
    }

    private static void setBytes(PreparedStatementMirror mirror, int parameterIndex, byte[] x) {
        boolean displayAsHex = JdbcInstrumentationProperties.displayBinaryParameterAsHex(mirror.getSql(), parameterIndex);
        mirror.setParameterValue(parameterIndex, new PreparedStatementMirror.ByteArrayParameterValue(x, displayAsHex));
    }

    private static <T extends Statement & HasStatementMirrorMixin> void captureExplainPlan(T statement, String sql, QuerySpan querySpan) {
        StatementMessageSupplier messageSupplier = (StatementMessageSupplier)querySpan.getMessageSupplier();
        if (messageSupplier == null) {
            return;
        }
        if (!StatementInstrumentation.startsWithCaseInsensitive(sql, "SELECT ")) {
            return;
        }
        try {
            Connection connection;
            try {
                connection = statement.getConnection();
            }
            catch (ClassCastException e) {
                return;
            }
            String dest = ConnectionInstrumentation.getDest(connection);
            if (dest.startsWith("jdbc:mysql:") || dest.startsWith("jdbc:postgresql:") || dest.startsWith("jdbc:h2:")) {
                messageSupplier.setExplainPlan(StatementInstrumentation.captureExplainQuery(connection, "EXPLAIN " + sql));
            } else if (dest.startsWith("jdbc:oracle:")) {
                messageSupplier.setExplainPlan(StatementInstrumentation.captureExplainQuery(connection, "EXPLAIN PLAN FOR " + sql));
            }
        }
        catch (Exception e) {
            if (explainPlanExceptionLogged.getAndSet(true)) {
                logger.debug(e.getMessage(), e);
            }
            logger.warn(e.getMessage(), e);
        }
    }

    private static boolean startsWithCaseInsensitive(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object captureExplainQuery(Connection connection, String query) throws SQLException {
        Statement statement = null;
        ResultSet rs = null;
        try {
            Object explainPlan;
            statement = connection.createStatement();
            rs = statement.executeQuery(query);
            if (!rs.next()) {
                String string = "[empty explain plan]";
                return string;
            }
            int columns = rs.getMetaData().getColumnCount();
            if (columns == 1) {
                explainPlan = rs.getString(1);
                if (explainPlan == null) {
                    explainPlan = "[empty explain plan]";
                }
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    map.put(rs.getMetaData().getColumnName(i), rs.getString(i));
                }
                explainPlan = map;
            }
            if (rs.next() && !explainPlanMultipleRowsLogged.getAndSet(true)) {
                logger.info("explain plan unexpectedly returned more than one row, please report this to https://github.com/glowroot/instrumentation");
            }
            String string = explainPlan;
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
        }
    }

    static {
        explainPlanExceptionLogged = new AtomicBoolean();
        explainPlanMultipleRowsLogged = new AtomicBoolean();
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                captureBindParameters = !configService.getListProperty("captureBindParametersIncludes").value().isEmpty();
            }
        });
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="close", methodParameterTypes={}, nestingGroup="jdbc")
    public static class CloseAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.This HasStatementMirrorMixin statement, ThreadContext context) {
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.clearLastQuerySpan();
            }
            if (captureStatementClose.value()) {
                return context.startTimer(STATEMENT_CLOSE_TIMER_NAME);
            }
            return null;
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="getResultSet", methodParameterTypes={".."}, methodReturnType="java.sql.ResultSet")
    public static class StatementGetResultSetAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable HasStatementMirrorMixin resultSet, @Bind.This HasStatementMirrorMixin statement) {
            if (resultSet == null) {
                return;
            }
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            resultSet.glowroot$setStatementMirror(mirror);
        }
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="executeBatch", methodParameterTypes={}, nestingGroup="jdbc")
    public static class StatementExecuteBatchAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        public static QuerySpan onBefore(@Bind.This HasStatementMirrorMixin statement, ThreadContext context) {
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (statement instanceof PreparedStatement) {
                return StatementInstrumentation.onBeforeBatchPreparedStatement((PreparedStatementMirror)mirror, context);
            }
            return StatementInstrumentation.onBeforeBatchStatement(mirror, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return int[] rowCounts, @Bind.Enter QuerySpan querySpan) {
            int totalRowCount = 0;
            boolean count = false;
            for (int rowCount : rowCounts) {
                if (rowCount <= 0) continue;
                totalRowCount += rowCount;
                count = true;
            }
            if (count) {
                querySpan.setCurrRow(totalRowCount);
            }
            querySpan.endWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter QuerySpan querySpan) {
            querySpan.endWithError(t);
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="executeUpdate", methodParameterTypes={}, methodReturnType="int", nestingGroup="jdbc")
    public static class PreparedStatementExecuteUpdateAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin preparedStatement) {
            return preparedStatement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        public static QuerySpan onBefore(@Bind.This HasStatementMirrorMixin preparedStatement, ThreadContext context) {
            return StatementInstrumentation.onBeforePreparedStatement(preparedStatement, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return int rowCount, @Bind.Enter QuerySpan querySpan) {
            querySpan.setCurrRow(rowCount);
            querySpan.endWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter QuerySpan querySpan) {
            querySpan.endWithError(t);
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="executeQuery", methodParameterTypes={}, methodReturnType="java.sql.ResultSet", nestingGroup="jdbc")
    public static class PreparedStatementExecuteQueryAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin preparedStatement) {
            return preparedStatement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        public static QuerySpan onBefore(@Bind.This HasStatementMirrorMixin preparedStatement, ThreadContext context) {
            return StatementInstrumentation.onBeforePreparedStatement(preparedStatement, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable HasStatementMirrorMixin resultSet, @Bind.This HasStatementMirrorMixin preparedStatement, @Bind.Enter QuerySpan querySpan) {
            if (resultSet != null) {
                StatementMirror mirror = preparedStatement.glowroot$getStatementMirror();
                resultSet.glowroot$setStatementMirror(mirror);
            }
            querySpan.endWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter QuerySpan querySpan) {
            querySpan.endWithError(t);
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="execute", methodParameterTypes={}, nestingGroup="jdbc")
    public static class PreparedStatementExecuteAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin preparedStatement) {
            return preparedStatement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        public static QuerySpan onBefore(@Bind.This HasStatementMirrorMixin preparedStatement, ThreadContext context) {
            return StatementInstrumentation.onBeforePreparedStatement(preparedStatement, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter QuerySpan querySpan) {
            querySpan.endWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter QuerySpan querySpan) {
            querySpan.endWithError(t);
        }
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="executeUpdate", methodParameterTypes={"java.lang.String", ".."}, methodReturnType="int", nestingGroup="jdbc")
    public static class StatementExecuteUpdateAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        @Nullable
        public static QuerySpan onBefore(@Bind.This HasStatementMirrorMixin statement, @Bind.Argument(value=0) @Nullable String sql, ThreadContext context) {
            return StatementInstrumentation.onBeforeStatement(statement, sql, QueryMessageSupplier.create(), context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return int rowCount, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.setCurrRow(rowCount);
                querySpan.endWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="executeQuery", methodParameterTypes={"java.lang.String"}, methodReturnType="java.sql.ResultSet", nestingGroup="jdbc")
    public static class StatementExecuteQueryAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        @Nullable
        public static QuerySpan onBefore(@Bind.This HasStatementMirrorMixin statement, @Bind.Argument(value=0) @Nullable String sql, ThreadContext context) {
            return StatementInstrumentation.onBeforeStatement(statement, sql, new StatementMessageSupplier(), context);
        }

        @Advice.OnMethodReturn
        public static <T extends Statement & HasStatementMirrorMixin> void onReturn(@Bind.Return @Nullable HasStatementMirrorMixin resultSet, @Bind.This T statement, @Bind.Argument(value=0) @Nullable String sql, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (resultSet != null) {
                StatementMirror mirror = ((HasStatementMirrorMixin)statement).glowroot$getStatementMirror();
                resultSet.glowroot$setStatementMirror(mirror);
            }
            if (querySpan != null) {
                long totalNanos = querySpan.partOneEndWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
                if (totalNanos >= JdbcInstrumentationProperties.explainPlanThresholdNanos() && sql != null) {
                    StatementInstrumentation.captureExplainPlan(statement, sql, querySpan);
                }
                querySpan.partTwoEnd();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="execute", methodParameterTypes={"java.lang.String", ".."}, nestingGroup="jdbc")
    public static class StatementExecuteAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This HasStatementMirrorMixin statement) {
            return statement.glowroot$hasStatementMirror();
        }

        @Advice.OnMethodBefore
        @Nullable
        public static QuerySpan onBefore(@Bind.This HasStatementMirrorMixin statement, @Bind.Argument(value=0) @Nullable String sql, ThreadContext context) {
            return StatementInstrumentation.onBeforeStatement(statement, sql, new StatementMessageSupplier(), context);
        }

        @Advice.OnMethodReturn
        public static <T extends Statement & HasStatementMirrorMixin> void onReturn(@Bind.This T statement, @Bind.Argument(value=0) @Nullable String sql, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                long totalNanos = querySpan.partOneEndWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
                if (totalNanos >= JdbcInstrumentationProperties.explainPlanThresholdNanos() && sql != null) {
                    StatementInstrumentation.captureExplainPlan(statement, sql, querySpan);
                }
                querySpan.partTwoEnd();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="clearBatch", methodParameterTypes={})
    public static class ClearBatchAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin statement) {
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.clearBatch();
            }
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="addBatch", methodParameterTypes={})
    public static class PreparedStatementAddBatchAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin preparedStatement) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.addBatch();
            }
        }
    }

    @Advice.Pointcut(className="java.sql.Statement", methodName="addBatch", methodParameterTypes={"java.lang.String"})
    public static class StatementAddBatchAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin statement, @Bind.Argument(value=0) @Nullable String sql) {
            if (sql == null) {
                return;
            }
            StatementMirror mirror = statement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.addBatch(sql);
            }
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="clearParameters", methodParameterTypes={})
    public static class ClearParametersAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin preparedStatement) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.clearParameters();
            }
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="setNull", methodParameterTypes={"int", "int", ".."})
    public static class SetNullAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin preparedStatement, @Bind.Argument(value=0) int parameterIndex) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.setParameterValue(parameterIndex, null);
            }
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="setObject", methodParameterTypes={"int", "java.lang.Object", ".."})
    public static class SetObjectAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin preparedStatement, @Bind.Argument(value=0) int parameterIndex, @Bind.Argument(value=1) @Nullable Object x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                if (x == null) {
                    mirror.setParameterValue(parameterIndex, null);
                } else if (x instanceof byte[]) {
                    StatementInstrumentation.setBytes(mirror, parameterIndex, (byte[])x);
                } else {
                    mirror.setParameterValue(parameterIndex, x);
                }
            }
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="setBytes", methodParameterTypes={"int", "byte[]"})
    public static class SetBytesAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin preparedStatement, @Bind.Argument(value=0) int parameterIndex, @Bind.Argument(value=1) byte[] x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                if (x == null) {
                    mirror.setParameterValue(parameterIndex, null);
                } else {
                    StatementInstrumentation.setBytes(mirror, parameterIndex, x);
                }
            }
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="setAsciiStream|setBinaryStream|setBlob|setCharacterStream|setClob|setNCharacterStream|setNClob|setSQLXML|setUnicodeStream", methodParameterTypes={"int", "*", ".."})
    public static class SetStreamAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin preparedStatement, @Bind.Argument(value=0) int parameterIndex, @Bind.Argument(value=1) @Nullable Object x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                if (x == null) {
                    mirror.setParameterValue(parameterIndex, null);
                } else {
                    mirror.setParameterValue(parameterIndex, new PreparedStatementMirror.StreamingParameterValue(x.getClass()));
                }
            }
        }
    }

    @Advice.Pointcut(className="java.sql.PreparedStatement", methodName="setArray|setBigDecimal|setBoolean|setByte|setDate|setDouble|setFloat|setInt|setLong|setNString|setRef|setRowId|setShort|setString|setTime|setTimestamp|setURL", methodParameterTypes={"int", "*", ".."})
    public static class SetXAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled() {
            return captureBindParameters;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HasStatementMirrorMixin preparedStatement, @Bind.Argument(value=0) int parameterIndex, @Bind.Argument(value=1) @Nullable Object x) {
            PreparedStatementMirror mirror = (PreparedStatementMirror)preparedStatement.glowroot$getStatementMirror();
            if (mirror != null) {
                mirror.setParameterValue(parameterIndex, x);
            }
        }
    }

    public static interface HasStatementMirrorMixin {
        @Nullable
        public StatementMirror glowroot$getStatementMirror();

        public void glowroot$setStatementMirror(@Nullable StatementMirror var1);

        public boolean glowroot$hasStatementMirror();
    }

    @Mixin(value={"java.sql.Statement", "java.sql.ResultSet"})
    public static class HasStatementMirrorImpl
    implements HasStatementMirrorMixin {
        @Nullable
        private transient StatementMirror glowroot$statementMirror;

        @Override
        @Nullable
        public StatementMirror glowroot$getStatementMirror() {
            return this.glowroot$statementMirror;
        }

        @Override
        public void glowroot$setStatementMirror(@Nullable StatementMirror statementMirror) {
            this.glowroot$statementMirror = statementMirror;
        }

        @Override
        public boolean glowroot$hasStatementMirror() {
            return this.glowroot$statementMirror != null;
        }
    }
}

