/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc.boot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.jdbc.boot.BindParameterList;

public class BatchPreparedStatementMessageSupplier
extends QueryMessageSupplier {
    private final List<BindParameterList> batchedParameters;
    private final int batchCount;

    public BatchPreparedStatementMessageSupplier(List<BindParameterList> batchedParameters, int batchCount) {
        this.batchedParameters = batchedParameters;
        this.batchCount = batchCount;
    }

    public Map<String, Object> get() {
        if (this.batchedParameters.isEmpty()) {
            return Collections.singletonMap("batchCount", this.batchCount);
        }
        HashMap<String, Object> details = new HashMap<String, Object>(2);
        details.put("batchCount", this.batchCount);
        details.put("parameters", this.getParameters());
        return details;
    }

    private List<List<Object>> getParameters() {
        ArrayList<List<Object>> parameters = new ArrayList<List<Object>>(this.batchedParameters.size());
        for (BindParameterList oneParameters : this.batchedParameters) {
            parameters.add(oneParameters.toDetailList());
        }
        return parameters;
    }
}

