/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc.boot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.jdbc.boot.BindParameterList;
import org.glowroot.instrumentation.jdbc.boot.StatementMirror;

public class PreparedStatementMirror
extends StatementMirror {
    private static final int CAPTURED_BATCH_COUNT_LIMIT = 1000;
    private static final int PARAMETERS_INITIAL_CAPACITY = 4;
    private final String sql;
    private BindParameterList parameters;
    private boolean parametersShared;
    @Nullable
    private List<BindParameterList> batchedParameters;
    private int batchCount;

    public PreparedStatementMirror(String dest, String sql) {
        super(dest);
        this.sql = sql;
        this.parameters = new BindParameterList(4);
    }

    public void addBatch() {
        if (this.batchedParameters == null) {
            this.batchedParameters = new ArrayList<BindParameterList>();
        }
        if (this.batchCount++ < 1000) {
            this.batchedParameters.add(this.parameters);
            this.parametersShared = true;
        }
    }

    public List<BindParameterList> getBatchedParameters() {
        if (this.batchedParameters == null) {
            return Collections.emptyList();
        }
        return this.batchedParameters;
    }

    @Nullable
    public BindParameterList getParameters() {
        this.parametersShared = true;
        return this.parameters;
    }

    public String getSql() {
        return this.sql;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public void setParameterValue(int parameterIndex, @Nullable Object object) {
        if (this.parametersShared) {
            this.copyParameters();
        }
        this.parameters.set(parameterIndex - 1, object);
    }

    private void copyParameters() {
        this.parameters = BindParameterList.copyOf(this.parameters);
        this.parametersShared = false;
    }

    public void clearParameters() {
        if (this.parametersShared) {
            this.parameters = new BindParameterList(this.parameters.size());
            this.parametersShared = false;
        } else {
            this.parameters.clear();
        }
    }

    @Override
    public void clearBatch() {
        if (this.parametersShared) {
            this.parameters = new BindParameterList(this.parameters.size());
            this.parametersShared = false;
        } else {
            this.parameters.clear();
        }
        this.batchedParameters = null;
        this.batchCount = 0;
    }

    public static class StreamingParameterValue {
        private final Class<?> clazz;

        public StreamingParameterValue(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            return "{stream:" + this.clazz.getSimpleName() + "}";
        }
    }

    public static class ByteArrayParameterValue {
        private static final char[] hexDigits = "0123456789abcdef".toCharArray();
        private final int length;
        private final byte[] bytes;

        public ByteArrayParameterValue(byte[] bytes, boolean displayAsHex) {
            this.length = bytes.length;
            this.bytes = (byte[])(displayAsHex ? bytes : null);
        }

        public String toString() {
            if (this.bytes != null) {
                StringBuilder sb = new StringBuilder(2 + 2 * this.bytes.length);
                sb.append("0x");
                for (byte b : this.bytes) {
                    sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
                }
                return sb.toString();
            }
            return "{" + this.length + " bytes}";
        }
    }
}

