/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.log4j;

import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.log4j.boot.LogMessageSupplier;
import org.glowroot.instrumentation.log4j.boot.LoggerInstrumentationProperties;

public class Log4j1xInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("logging");

    @Advice.Pointcut(className="org.apache.log4j.Category", methodName="forcedLog", methodParameterTypes={"java.lang.String", "org.apache.log4j.Priority", "java.lang.Object", "java.lang.Throwable"}, nestingGroup="logging")
    public static class ForcedLogAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=1) @Nullable Priority level) {
            return level != null && LoggerInstrumentationProperties.captureLog4j1xLevel(level.toInt());
        }

        @Advice.OnMethodBefore
        public static Timer onBefore(@Bind.This Category logger, @Bind.Argument(value=1) @Nullable Priority level, @Bind.Argument(value=2) @Nullable Object message, @Bind.Argument(value=3) @Nullable Throwable t, ThreadContext context) {
            String messageText = String.valueOf(message);
            int lvl = level == null ? 0 : level.toInt();
            if (LoggerInstrumentationProperties.markTraceAsError(lvl >= 40000, lvl >= 30000, t != null)) {
                context.setTransactionError(messageText, t);
            }
            context.captureLoggerSpan(new LogMessageSupplier(messageText, level == null ? null : level.toString(), logger.getName()), t);
            return context.startTimer(TIMER_NAME);
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter Timer timer) {
            timer.stop();
        }
    }
}

