/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.log4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.log4j.boot.LogMessageSupplier;
import org.glowroot.instrumentation.log4j.boot.LoggerInstrumentationProperties;

public class Log4j2xInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("logging");

    private static String nullToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    @Advice.Pointcut(className="org.apache.logging.log4j.spi.ExtendedLogger", methodName="logMessage", methodParameterTypes={"java.lang.String", "org.apache.logging.log4j.Level", "org.apache.logging.log4j.Marker", "org.apache.logging.log4j.message.Message", "java.lang.Throwable"}, nestingGroup="logging")
    public static class CallAppendersAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=1) @Nullable Level level) {
            return level != null && LoggerInstrumentationProperties.captureLog4j2xLevel(level.intLevel());
        }

        @Advice.OnMethodBefore
        public static Timer onBefore(@Bind.This Logger logger, @Bind.Argument(value=1) @Nullable Level level, @Bind.Argument(value=3) @Nullable Message message, @Bind.Argument(value=4) @Nullable Throwable t, ThreadContext context) {
            String formattedMessage = message == null ? "" : Log4j2xInstrumentation.nullToEmpty(message.getFormattedMessage());
            int lvl = level == null ? 0 : level.intLevel();
            if (LoggerInstrumentationProperties.markTraceAsError(lvl <= 200, lvl <= 300, t != null)) {
                context.setTransactionError(formattedMessage, t);
            }
            context.captureLoggerSpan(new LogMessageSupplier(formattedMessage, level == null ? null : level.toString(), logger.getName()), t);
            return context.startTimer(TIMER_NAME);
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter Timer timer) {
            timer.stop();
        }
    }
}

