/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.logback.boot;

import java.util.Locale;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;

public class LoggerInstrumentationProperties {
    private static final Logger logger = Logger.getLogger(LoggerInstrumentationProperties.class);
    private static final ConfigService configService = Agent.getConfigService("logback");
    private static int threshold;
    private static final BooleanProperty traceErrorOnWarningWithThrowable;
    private static final BooleanProperty traceErrorOnWarningWithoutThrowable;
    private static final BooleanProperty traceErrorOnErrorWithThrowable;
    private static final BooleanProperty traceErrorOnErrorWithoutThrowable;

    private LoggerInstrumentationProperties() {
    }

    public static boolean captureLevel(int level) {
        return level >= threshold;
    }

    public static boolean markTraceAsError(boolean isErrorOrHigher, boolean isWarnOrHigher, boolean throwable) {
        if (isErrorOrHigher) {
            return throwable ? traceErrorOnErrorWithThrowable.value() : traceErrorOnErrorWithoutThrowable.value();
        }
        if (isWarnOrHigher) {
            return throwable ? traceErrorOnWarningWithThrowable.value() : traceErrorOnWarningWithoutThrowable.value();
        }
        return false;
    }

    static {
        traceErrorOnWarningWithThrowable = configService.getBooleanProperty("traceErrorOnWarningWithThrowable");
        traceErrorOnWarningWithoutThrowable = configService.getBooleanProperty("traceErrorOnWarningWithoutThrowable");
        traceErrorOnErrorWithThrowable = configService.getBooleanProperty("traceErrorOnErrorWithThrowable");
        traceErrorOnErrorWithoutThrowable = configService.getBooleanProperty("traceErrorOnErrorWithoutThrowable");
        configService.registerConfigListener(new ConfigListenerImpl());
    }

    private static class ConfigListenerImpl
    implements ConfigListener {
        private ConfigListenerImpl() {
        }

        @Override
        public void onChange() {
            String thresholdStr = configService.getStringProperty("threshold").value().toLowerCase(Locale.ENGLISH);
            if (thresholdStr.equals("")) {
                threshold = Integer.MIN_VALUE;
            } else if (thresholdStr.equals("error")) {
                threshold = 40000;
            } else if (thresholdStr.equals("warn")) {
                threshold = 30000;
            } else if (thresholdStr.equals("info")) {
                threshold = 20000;
            } else if (thresholdStr.equals("debug")) {
                threshold = 10000;
            } else if (thresholdStr.equals("trace")) {
                threshold = 5000;
            } else {
                logger.warn("unexpected configuration for threshold: {}", (Object)threshold);
                threshold = Integer.MIN_VALUE;
            }
        }
    }
}

