/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.logback.boot;

import java.lang.reflect.Method;
import org.glowroot.instrumentation.api.ClassInfo;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.util.Reflection;

public class LoggingEventInvoker {
    private static final Logger logger = Logger.getLogger(LoggingEventInvoker.class);
    @Nullable
    private final Method getLoggerNameMethod;
    @Nullable
    private final Method getFormattedMessageMethod;
    @Nullable
    private final Method getThrowableProxyMethod;
    @Nullable
    private final Method getThrowableMethod;
    @Nullable
    private final Method toIntMethod;

    public LoggingEventInvoker(ClassInfo classInfo) {
        Class<?> loggerClass = Reflection.getClassWithWarnIfNotFound("ch.qos.logback.classic.Logger", classInfo.getLoader());
        this.getLoggerNameMethod = Reflection.getMethod(loggerClass, "getName", new Class[0]);
        Class<?> loggingEventClass = Reflection.getClassWithWarnIfNotFound("ch.qos.logback.classic.spi.LoggingEvent", classInfo.getLoader());
        this.getFormattedMessageMethod = Reflection.getMethod(loggingEventClass, "getFormattedMessage", new Class[0]);
        if (loggingEventClass == null) {
            this.getThrowableProxyMethod = null;
            this.getThrowableMethod = null;
        } else {
            Method localGetThrowableProxyMethod = null;
            Method localGetThrowableMethod = null;
            try {
                localGetThrowableProxyMethod = loggingEventClass.getMethod("getThrowableProxy", new Class[0]);
                Class<?> throwableProxyClass = Class.forName("ch.qos.logback.classic.spi.ThrowableProxy", false, classInfo.getLoader());
                localGetThrowableMethod = throwableProxyClass.getMethod("getThrowable", new Class[0]);
            }
            catch (Throwable t) {
                logger.debug(t.getMessage(), t);
                try {
                    localGetThrowableProxyMethod = loggingEventClass.getMethod("getThrowableInformation", new Class[0]);
                    Class<?> throwableInformationClass = Class.forName("ch.qos.logback.classic.spi.ThrowableInformation", false, classInfo.getLoader());
                    localGetThrowableMethod = Reflection.getMethod(throwableInformationClass, "getThrowable", new Class[0]);
                }
                catch (Throwable tt) {
                    logger.debug(tt.getMessage(), tt);
                    logger.warn(t.getMessage(), t);
                }
            }
            this.getThrowableProxyMethod = localGetThrowableProxyMethod;
            this.getThrowableMethod = localGetThrowableMethod;
        }
        Class<?> levelClass = Reflection.getClassWithWarnIfNotFound("ch.qos.logback.classic.Level", classInfo.getLoader());
        this.toIntMethod = Reflection.getMethod(levelClass, "toInt", new Class[0]);
    }

    public String getFormattedMessage(Object loggingEvent) {
        return Reflection.invokeWithDefault(this.getFormattedMessageMethod, loggingEvent, "", new Object[0]);
    }

    @Nullable
    public Throwable getThrowable(Object loggingEvent) {
        Object throwableInformation = Reflection.invoke(this.getThrowableProxyMethod, loggingEvent, new Object[0]);
        if (throwableInformation == null) {
            return null;
        }
        return (Throwable)Reflection.invoke(this.getThrowableMethod, throwableInformation, new Object[0]);
    }

    public String getLoggerName(Object logger) {
        return Reflection.invokeWithDefault(this.getLoggerNameMethod, logger, "", new Object[0]);
    }
}

