/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.mongodb;

import java.util.concurrent.TimeUnit;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Shim;

public class DBCollectionInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("mongodb query");
    private static final String QUERY_TYPE = "MongoDB";
    private static final ConfigService configService = Agent.getConfigService("mongodb");
    private static long stackTraceThresholdNanos;

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                Double value = configService.getDoubleProperty("stackTraceThresholdMillis").value();
                stackTraceThresholdNanos = value == null ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(value.intValue());
            }
        });
    }

    @Advice.Pointcut(className="com.mongodb.DBCollection", methodName="count|getCount|distinct|find*|aggregate|group|mapReduce|insert|remove|save|update*|drop*|create*|ensure*|rename*", methodParameterTypes={".."}, nestingGroup="mongodb")
    public static class DBCollectionAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static QuerySpan onBefore(@Bind.This DBCollection collection, @Bind.MethodName String methodName, ThreadContext context) {
            if (methodName.equals("getCount")) {
                methodName = "count";
            }
            String queryText = methodName + " " + collection.getFullName();
            return context.startQuerySpan(DBCollectionInstrumentation.QUERY_TYPE, "", queryText, QueryMessageSupplier.create(), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithLocationStackTrace(stackTraceThresholdNanos);
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithError(t);
            }
        }
    }

    @Shim(value={"com.mongodb.DBCollection"})
    public static interface DBCollection {
        @Nullable
        public String getFullName();
    }
}

