/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.mongodb;

import java.util.concurrent.TimeUnit;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Shim;
import org.glowroot.instrumentation.mongodb.MongoIterableInstrumentation;

public class MongoCollectionInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("mongodb query");
    private static final String QUERY_TYPE = "MongoDB";
    private static final ConfigService configService = Agent.getConfigService("mongodb");
    private static long stackTraceThresholdNanos;

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                Double value = configService.getDoubleProperty("stackTraceThresholdMillis").value();
                stackTraceThresholdNanos = value == null ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(value.intValue());
            }
        });
    }

    @Advice.Pointcut(className="com.mongodb.client.MongoCollection", methodName="find|aggregate", methodParameterTypes={".."}, nestingGroup="mongodb")
    public static class MongoFindAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static QuerySpan onBefore(@Bind.This MongoCollection collection, @Bind.MethodName String methodName, ThreadContext context) {
            Object namespace = collection.getNamespace();
            if (namespace == null) {
                return null;
            }
            String queryText = methodName + " " + namespace.toString();
            return context.startQuerySpan(MongoCollectionInstrumentation.QUERY_TYPE, "", queryText, QueryMessageSupplier.create(), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return MongoIterableInstrumentation.MongoIterableMixin mongoIterable, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                if (mongoIterable != null) {
                    mongoIterable.glowroot$setQuerySpan(querySpan);
                }
                querySpan.endWithLocationStackTrace(stackTraceThresholdNanos);
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="com.mongodb.client.MongoCollection", methodName="count*|distinct|findOneAnd*|mapReduce|bulkWrite|insert*|delete*|replace|update*|drop*|create*|list*|rename*", methodParameterTypes={".."}, nestingGroup="mongodb")
    public static class MongoCollectionAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static QuerySpan onBefore(@Bind.This MongoCollection collection, @Bind.MethodName String methodName, ThreadContext context) {
            Object namespace = collection.getNamespace();
            if (namespace == null) {
                return null;
            }
            String queryText = methodName + " " + namespace.toString();
            return context.startQuerySpan(MongoCollectionInstrumentation.QUERY_TYPE, "", queryText, QueryMessageSupplier.create(), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithLocationStackTrace(stackTraceThresholdNanos);
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable QuerySpan querySpan) {
            if (querySpan != null) {
                querySpan.endWithError(t);
            }
        }
    }

    @Shim(value={"com.mongodb.client.MongoCollection"})
    public static interface MongoCollection {
        @Shim(value={"com.mongodb.MongoNamespace getNamespace()"})
        @Nullable
        public Object getNamespace();
    }
}

