/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.mongodb;

import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;

public class MongoCursorInstrumentation {

    @Advice.Pointcut(className="com.mongodb.client.MongoCursor", methodName="hasNext", methodParameterTypes={}, nestingGroup="mongodb")
    public static class IsExhaustedAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.This MongoCursorMixin mongoCursor) {
            QuerySpan querySpan = mongoCursor.glowroot$getQuerySpan();
            return querySpan == null ? null : querySpan.extend();
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This MongoCursorMixin mongoCursor) {
            QuerySpan querySpan = mongoCursor.glowroot$getQuerySpan();
            if (querySpan == null) {
                return;
            }
            querySpan.rowNavigationAttempted();
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Advice.Pointcut(className="com.mongodb.client.MongoCursor", methodName="next|tryNext", methodParameterTypes={}, nestingGroup="mongodb")
    public static class FirstAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.This MongoCursorMixin mongoCursor) {
            QuerySpan querySpan = mongoCursor.glowroot$getQuerySpan();
            return querySpan == null ? null : querySpan.extend();
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable Object document, @Bind.This MongoCursorMixin mongoIterable) {
            QuerySpan querySpan = mongoIterable.glowroot$getQuerySpan();
            if (querySpan == null) {
                return;
            }
            if (document != null) {
                querySpan.incrementCurrRow();
            } else {
                querySpan.rowNavigationAttempted();
            }
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    public static interface MongoCursorMixin {
        @Nullable
        public QuerySpan glowroot$getQuerySpan();

        public void glowroot$setQuerySpan(@Nullable QuerySpan var1);
    }

    @Mixin(value={"com.mongodb.client.MongoCursor"})
    public static class MongoCursorImpl
    implements MongoCursorMixin {
        @Nullable
        private transient QuerySpan glowroot$querySpan;

        @Override
        @Nullable
        public QuerySpan glowroot$getQuerySpan() {
            return this.glowroot$querySpan;
        }

        @Override
        public void glowroot$setQuerySpan(@Nullable QuerySpan querySpan) {
            this.glowroot$querySpan = querySpan;
        }
    }
}

