/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.mongodb;

import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;
import org.glowroot.instrumentation.mongodb.MongoCursorInstrumentation;

public class MongoIterableInstrumentation {

    @Advice.Pointcut(className="com.mongodb.client.MongoIterable", subTypeRestriction="com.mongodb.client.FindIterable|com.mongodb.client.AggregateIterable", methodName="iterator", methodParameterTypes={}, methodReturnType="com.mongodb.client.MongoCursor", nestingGroup="mongodb")
    public static class IteratorAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable MongoCursorInstrumentation.MongoCursorMixin mongoCursor, @Bind.This MongoIterableMixin mongoIterable) {
            if (mongoCursor != null) {
                mongoCursor.glowroot$setQuerySpan(mongoIterable.glowroot$getQuerySpan());
            }
        }
    }

    @Advice.Pointcut(className="com.mongodb.client.MongoIterable", subTypeRestriction="com.mongodb.client.FindIterable|com.mongodb.client.AggregateIterable", methodName="first", methodParameterTypes={}, nestingGroup="mongodb")
    public static class FirstAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.This MongoIterableMixin mongoIterable) {
            QuerySpan querySpan = mongoIterable.glowroot$getQuerySpan();
            return querySpan == null ? null : querySpan.extend();
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable Object document, @Bind.This MongoIterableMixin mongoIterable) {
            QuerySpan querySpan = mongoIterable.glowroot$getQuerySpan();
            if (querySpan == null) {
                return;
            }
            if (document != null) {
                querySpan.incrementCurrRow();
            } else {
                querySpan.rowNavigationAttempted();
            }
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Advice.Pointcut(className="com.mongodb.client.FindIterable", methodName="*", methodParameterTypes={".."}, methodReturnType="com.mongodb.client.FindIterable")
    public static class MapAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable MongoIterableMixin newMongoIterable, @Bind.This MongoIterableMixin mongoIterable) {
            if (newMongoIterable != null) {
                newMongoIterable.glowroot$setQuerySpan(mongoIterable.glowroot$getQuerySpan());
            }
        }
    }

    public static interface MongoIterableMixin {
        @Nullable
        public QuerySpan glowroot$getQuerySpan();

        public void glowroot$setQuerySpan(@Nullable QuerySpan var1);
    }

    @Mixin(value={"com.mongodb.client.FindIterable", "com.mongodb.client.AggregateIterable"})
    public static class MongoIterableImpl
    implements MongoIterableMixin {
        @Nullable
        private transient QuerySpan glowroot$querySpan;

        @Override
        @Nullable
        public QuerySpan glowroot$getQuerySpan() {
            return this.glowroot$querySpan;
        }

        @Override
        public void glowroot$setQuerySpan(@Nullable QuerySpan querySpan) {
            this.glowroot$querySpan = querySpan;
        }
    }
}

