/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.okhttp.OkHttp2xResponseGetter;
import org.glowroot.instrumentation.okhttp.boot.HttpRequestMessageSupplier;

class OkHttp2xCallbackWrapper
implements Callback {
    private final Callback delegate;
    private final AsyncSpan span;
    private final AuxThreadContext auxContext;

    OkHttp2xCallbackWrapper(Callback delegate, AsyncSpan span, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.span = span;
        this.auxContext = auxContext;
    }

    public void onFailure(Request request, IOException exception) {
        this.span.endWithError(exception);
        Span span = this.auxContext.start();
        try {
            this.delegate.onFailure(request, exception);
        }
        catch (Throwable t) {
            span.endWithError(t);
            throw OkHttp2xCallbackWrapper.rethrow(t);
        }
        span.end();
    }

    public void onResponse(Response response) throws IOException {
        HttpRequestMessageSupplier supplier = (HttpRequestMessageSupplier)this.span.getMessageSupplier();
        if (supplier != null) {
            supplier.setStatusCode(response.code());
        }
        this.span.extractFromResponse(response, OkHttp2xResponseGetter.INSTANCE);
        this.span.end();
        Span span = this.auxContext.start();
        try {
            this.delegate.onResponse(response);
        }
        catch (Throwable t) {
            span.endWithError(t);
            throw OkHttp2xCallbackWrapper.rethrow(t);
        }
        span.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        OkHttp2xCallbackWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

