/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.util.HashMap;
import java.util.Map;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.api.ParameterHolder;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;
import org.glowroot.instrumentation.okhttp.OkHttp2xCallbackWrapper;
import org.glowroot.instrumentation.okhttp.OkHttp2xCallbackWrapperForNullDelegate;
import org.glowroot.instrumentation.okhttp.boot.CallInvoker;
import org.glowroot.instrumentation.okhttp.boot.HttpRequestMessageSupplier;
import org.glowroot.instrumentation.okhttp.boot.Util;

public class OkHttp2xInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("http client request");
    private static final Setter<Map<String, String>> SETTER = new SetterImpl();

    private static Callback createWrapper(ParameterHolder<Callback> callback, AsyncSpan span, ThreadContext context) {
        Callback delegate = callback.get();
        if (delegate == null) {
            return new OkHttp2xCallbackWrapperForNullDelegate(span);
        }
        return new OkHttp2xCallbackWrapper(delegate, span, context.createAuxThreadContext());
    }

    private static class SetterImpl
    implements Setter<Map<String, String>> {
        private SetterImpl() {
        }

        @Override
        public void put(Map<String, String> carrier, String key, String value) {
            carrier.put(key, value);
        }
    }

    @Advice.Pointcut(className="com.squareup.okhttp.Call", methodName="getResponse", methodParameterTypes={"com.squareup.okhttp.Request", "boolean"})
    public static class PropagateAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) ParameterHolder<Request> requestHolder) {
            Request request = requestHolder.get();
            if (request == null) {
                return;
            }
            RequestMixin requestMixin = (RequestMixin)RequestMixin.class.cast(request);
            Map<String, String> extraHeaders = requestMixin.glowroot$getExtraHeaders();
            if (extraHeaders == null) {
                return;
            }
            Request.Builder builder = request.newBuilder();
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            requestHolder.set(builder.build());
        }
    }

    @Advice.Pointcut(className="com.squareup.okhttp.Call", methodName="enqueue", methodParameterTypes={"com.squareup.okhttp.Callback"}, nestingGroup="http-client")
    public static class EnqueueAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static AsyncSpan onBefore(@Bind.This Object call, @Bind.Argument(value=0) ParameterHolder<Callback> callback, @Bind.ClassMeta CallInvoker callInvoker, ThreadContext context) {
            Request originalRequest = (Request)callInvoker.getOriginalRequest(call);
            if (originalRequest == null) {
                return null;
            }
            RequestMixin requestMixin = (RequestMixin)RequestMixin.class.cast(originalRequest);
            HashMap<String, String> extraHeaders = new HashMap<String, String>(4);
            requestMixin.glowroot$setExtraHeaders(extraHeaders);
            AsyncSpan span = Util.startAsyncOutgoingSpan(context, originalRequest.method(), originalRequest.urlString(), SETTER, extraHeaders, TIMER_NAME);
            callback.set(OkHttp2xInstrumentation.createWrapper(callback, span, context));
            return span;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable AsyncSpan span) {
            if (span != null) {
                span.stopSyncTimer();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable AsyncSpan span) {
            if (span != null) {
                span.stopSyncTimer();
                span.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="com.squareup.okhttp.Call", methodName="execute", methodParameterTypes={}, nestingGroup="http-client")
    public static class ExecuteAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.This Object call, @Bind.ClassMeta CallInvoker callInvoker, ThreadContext context) {
            Request originalRequest = (Request)callInvoker.getOriginalRequest(call);
            if (originalRequest == null) {
                return null;
            }
            RequestMixin requestMixin = (RequestMixin)RequestMixin.class.cast(originalRequest);
            HashMap<String, String> extraHeaders = new HashMap<String, String>(4);
            requestMixin.glowroot$setExtraHeaders(extraHeaders);
            return Util.startOutgoingSpan(context, originalRequest.method(), originalRequest.urlString(), SETTER, extraHeaders, TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return Response response, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                HttpRequestMessageSupplier supplier = (HttpRequestMessageSupplier)span.getMessageSupplier();
                if (supplier != null) {
                    supplier.setStatusCode(response.code());
                }
                span.end();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="com.squareup.okhttp.OkHttpClient", methodName="newCall", methodParameterTypes={"com.squareup.okhttp.Request"})
    public static class NewCallAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) ParameterHolder<Request> requestHolder) {
            Request request = requestHolder.get();
            if (request != null) {
                requestHolder.set(request.newBuilder().build());
            }
        }
    }

    public static interface RequestMixin {
        @Nullable
        public Map<String, String> glowroot$getExtraHeaders();

        public void glowroot$setExtraHeaders(Map<String, String> var1);
    }

    @Mixin(value={"com.squareup.okhttp.Request"})
    public static class RequestMixinImpl
    implements RequestMixin {
        @Nullable
        private volatile transient Map<String, String> glowroot$extraHeaders;

        @Override
        @Nullable
        public Map<String, String> glowroot$getExtraHeaders() {
            return this.glowroot$extraHeaders;
        }

        @Override
        public void glowroot$setExtraHeaders(Map<String, String> extraHeaders) {
            this.glowroot$extraHeaders = extraHeaders;
        }
    }
}

