/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.okhttp.OkHttp3xResponseGetter;
import org.glowroot.instrumentation.okhttp.boot.HttpRequestMessageSupplier;

class OkHttp3xCallbackWrapper
implements Callback {
    private final Callback delegate;
    private final AsyncSpan span;
    private final AuxThreadContext auxContext;

    OkHttp3xCallbackWrapper(Callback delegate, AsyncSpan span, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.span = span;
        this.auxContext = auxContext;
    }

    public void onFailure(Call call, IOException exception) {
        this.span.endWithError(exception);
        Span span = this.auxContext.start();
        try {
            this.delegate.onFailure(call, exception);
        }
        catch (Throwable t) {
            span.endWithError(t);
            throw OkHttp3xCallbackWrapper.rethrow(t);
        }
        span.end();
    }

    public void onResponse(Call call, Response response) throws IOException {
        HttpRequestMessageSupplier supplier = (HttpRequestMessageSupplier)this.span.getMessageSupplier();
        if (supplier != null) {
            supplier.setStatusCode(response.code());
        }
        this.span.extractFromResponse(response, OkHttp3xResponseGetter.INSTANCE);
        this.span.end();
        Span span = this.auxContext.start();
        try {
            this.delegate.onResponse(call, response);
        }
        catch (Throwable t) {
            span.endWithError(t);
            throw OkHttp3xCallbackWrapper.rethrow(t);
        }
        span.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        OkHttp3xCallbackWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

